/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;
import com.ifractal.desktop.ScannerNative;
import com.ifractal.utils.Producer;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScannerTest
extends Producer
implements ScannerListener<JPanel>,
MouseListener,
MouseMotionListener {
    JFrame frame = new JFrame("Scanner Teste");
    JPanel panel = new JPanel();
    Scanner<JPanel> scanner = null;
    int last_click = 0;

    public ScannerTest(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public void start() {
        String[][] scanners;
        this.frame.add(this.panel);
        this.frame.setSize(650, 500);
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(3);
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
        for (String[] scan : scanners = Scanner.getScanners()) {
            System.out.println(scan[0]);
        }
    }

    public void capture() {
        this.scanner = new ScannerNative<JPanel>(null, null, this);
        this.scanner.enumerate("OpenCV");
        this.scanner.init(0);
        byte[] quality = new byte[]{0};
        this.scanner.enroll(30, "1", quality, this.panel);
    }

    @Override
    public int onTemplate(Scanner<JPanel> scan, String vendor, String id, byte[] templ, byte quality, JPanel user_data) {
        try {
            FileOutputStream fos = new FileOutputStream("foto.jpg");
            fos.write(templ);
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int onImage(Scanner<JPanel> scan, byte[] imageBuf, int width, int height, JPanel user_data) {
        int bpp = imageBuf.length / (width * height);
        int type = 0;
        if (bpp == 1) {
            type = 10;
        } else if (bpp == 3) {
            type = 5;
        } else {
            return 0;
        }
        BufferedImage image = new BufferedImage(width, height, type);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = imageBuf[i];
        }
        Graphics g = user_data.getGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        int r = this.last_click;
        this.last_click = 0;
        return r;
    }

    @Override
    public int onMessage(Scanner<JPanel> scan, String msg, JPanel user_data) {
        System.out.println("onMessage: " + msg);
        return 0;
    }

    @Override
    public int onFinished(Scanner<JPanel> scan, int result, JPanel user_data) {
        return 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.last_click = e.getX() * 65536 + e.getY();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static final void main(String[] args) {
        ScannerTest test = new ScannerTest(null, args);
        test.start();
        test.capture();
    }
}

