/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.IfpontoDBAcesso;
import com.ifractal.ifponto.PushDevice;
import com.ifractal.utils.HttpServer;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0006\u0010\u000f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/ifractal/ifponto/DeviceThread;", "Ljava/lang/Runnable;", "db", "Lcom/ifractal/ifponto/IfpontoDB;", "dev", "Lcom/ifractal/ifponto/PushDevice;", "Lcom/ifractal/ifponto/IfpontoDBAcesso;", "(Lcom/ifractal/ifponto/IfpontoDB;Lcom/ifractal/ifponto/PushDevice;)V", "getDb", "()Lcom/ifractal/ifponto/IfpontoDB;", "getDev", "()Lcom/ifractal/ifponto/PushDevice;", "getEvents", "", "run", "sendUsersBio", "ifractal"})
public final class DeviceThread
implements Runnable {
    @NotNull
    private final IfpontoDB db;
    @NotNull
    private final PushDevice<IfpontoDBAcesso> dev;

    public DeviceThread(@NotNull IfpontoDB db, @NotNull PushDevice<IfpontoDBAcesso> dev) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(dev, (String)"dev");
        this.db = db;
        this.dev = dev;
    }

    @NotNull
    public final IfpontoDB getDb() {
        return this.db;
    }

    @NotNull
    public final PushDevice<IfpontoDBAcesso> getDev() {
        return this.dev;
    }

    public final void getEvents() {
        int nsr;
        this.dev.currentNSR = nsr = this.db.getNsr(this.dev.codigo);
        int last_nsr = 0;
        do {
            JSONArray offs;
            if ((last_nsr = this.dev.getEvents(offs = new JSONArray())) < this.dev.currentNSR) {
                return;
            }
            int r = this.db.updateOffs(this.dev.codigo, offs);
            if (r < 0) {
                return;
            }
            this.dev.currentNSR = last_nsr;
        } while (last_nsr > 0);
    }

    public final void sendUsersBio() {
        JSONArray jres = new JSONArray();
        JSONArray jusers = this.db.getPendingUsers(this.dev.codigo, 50);
        if (jusers != null && jusers.size() > 0) {
            int r = this.dev.sendUsers(jusers, jres);
            if (r < 0) {
                return;
            }
            this.db.updatePendingUsers(this.dev.codigo, jres);
            r = this.dev.sendBio(jusers, jres);
            if (r < 0) {
                return;
            }
            Thread.sleep(1000L);
            if (!this.dev.centralizador) {
                this.dev.sendBio(jusers, jres);
            }
        }
    }

    @Override
    public void run() {
        Date dt = this.dev.getTime();
        if (dt == null) {
            return;
        }
        this.dev.setTime_in(dt.getTime() / (long)1000);
        this.getEvents();
        this.sendUsersBio();
        this.dev.setAlive(true);
        while (HttpServer.isDeviceActive(this.dev) && this.dev.getAlive()) {
            System.out.println((Object)"|");
            Thread.sleep(1000L);
        }
    }
}

