/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.SIINListener;
import com.ifractal.ifponto.SIINServer;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.ConcurrentListener;
import com.ifractal.utils.FiledirIter;
import com.ifractal.utils.Getopts;
import com.ifractal.utils.IfaceFilePerform;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SIIN
extends Producer
implements Runnable {
    public static final String OS = System.getProperty("os.name").toLowerCase();
    public static final String PATH_OFFS = "offs";
    public static final String OFF_PREFIX = "off_";
    public static final String RESULT_PREFIX = "result_";
    public static final String ACESSO_PREFIX = "acesso";
    public static final String USER_PREFIX = "user_";
    public static final String STATUS_PREFIX = "status_";
    public static final String JSON_SUFFIX = ".json";
    private static SIINListener[] listeners = null;
    private static SIIN siin = null;
    private static Thread thread = null;
    protected static final HashSet<String> delete_files = new HashSet();
    protected static Observer observer = null;
    protected static boolean enabled = false;
    protected static boolean alive = false;
    protected IfpontoDB idb = null;
    public int progressPos = 0;
    public int progressTotal = 8;
    public String notify = "";
    IfaceFilePerform processFileIter = new IfaceFilePerform(){

        @Override
        public int filePerform(String filename, Object user_data) throws IOException {
            Object[] pars = (Object[])user_data;
            Producer prod = (Producer)pars[0];
            String[] cod_nro = new String[]{"0", "0"};
            File f = new File(filename);
            String name = f.getName();
            Object j = SIIN.this.parseFile(prod, filename, cod_nro);
            JSONObject jstatus = null;
            JSONArray json = null;
            if (j == null) {
                return 0;
            }
            if (name.startsWith(SIIN.STATUS_PREFIX) || name.startsWith(SIIN.ACESSO_PREFIX)) {
                jstatus = (JSONObject)j;
            } else {
                json = (JSONArray)j;
            }
            String codigo = cod_nro[0];
            String nro = cod_nro[1];
            if (codigo.equals("0") || nro.equals("0")) {
                return 0;
            }
            if (name.startsWith(SIIN.OFF_PREFIX)) {
                SIIN.this.idb.updateOffs(codigo, json);
            } else if (name.startsWith(SIIN.STATUS_PREFIX)) {
                SIIN.this.idb.updateStatus(codigo, jstatus);
            } else if (name.startsWith(SIIN.ACESSO_PREFIX)) {
                SIIN.this.idb.updateAcesso(jstatus);
            } else {
                if (name.startsWith(SIIN.RESULT_PREFIX)) {
                    SIIN.this.idb.updatePendingUsers(codigo, json);
                } else if (name.startsWith(SIIN.USER_PREFIX)) {
                    SIIN.this.idb.rollbackPendingUsers(json);
                }
                JSONArray interruptedUsers = SIIN.this.idb.getProcessingUsers(codigo);
                if (interruptedUsers != null && interruptedUsers.size() > 0) {
                    SIIN.this.idb.rollbackPendingUsers(interruptedUsers);
                }
            }
            f.delete();
            return 0;
        }
    };

    public static SIIN getInstance(String[] args, IfpontoDB db, SIINListener sl) {
        if (siin != null) {
            return siin;
        }
        siin = new SIIN(args, db, sl);
        thread = new Thread((Runnable)siin, "SIIN");
        return siin;
    }

    private SIIN(String[] args, IfpontoDB db, SIINListener sl) {
        super(sl);
        this.idb = db;
        observer = sl;
        this.addListener(sl);
    }

    protected void setEnable(boolean e) {
        enabled = e;
    }

    protected int addListener(SIINListener sl) {
        if (sl == null) {
            return 0;
        }
        if (listeners == null) {
            listeners = new SIINListener[]{sl};
            return 1;
        }
        int len = listeners.length;
        SIINListener[] list = new SIINListener[len + 1];
        for (int i = 0; i < len; ++i) {
            list[i] = listeners[i];
        }
        list[len] = sl;
        listeners = list;
        return len + 1;
    }

    protected void notifyLoop(boolean alive) {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            if (alive) {
                sl.onStart();
                continue;
            }
            sl.onStop();
            this.progressPos = 0;
            this.notify = "Modulo parado";
            this.notifyProgress();
        }
    }

    protected void notifyProgress() {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            sl.onProgress(this.progressTotal, this.progressPos, this.notify);
        }
    }

    protected void notifyFinalize(String msg) {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            if (msg == null) {
                sl.onSynchronized();
                this.progressPos = 8;
                this.notify = "Sincronizado";
                continue;
            }
            sl.onFail(msg);
            this.progressPos = 0;
            this.notify = "Falha na sincroniza\u00e7\u00e3o";
        }
        this.notifyProgress();
    }

    protected void notifyEnable(String key) {
        if (key == null) {
            this.setEnable(false);
        } else {
            this.setEnable(true);
        }
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            sl.onEnable(key);
        }
    }

    protected void notifyIdle() {
        int loop = 60;
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            sl.onIdle();
        }
        for (int i = 0; i < loop; ++i) {
            this.progressTotal = loop;
            this.progressPos = i;
            this.notify = null;
            this.notifyProgress();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void makeStatus(JSONObject jstatus, String msg) {
        long unixtime = new Date().getTime() / 1000L;
        jstatus.put((Object)"unixtime", (Object)unixtime);
        jstatus.put((Object)"msg", (Object)msg);
        jstatus.put((Object)"notificacoes", jstatus.get((Object)"msg"));
    }

    protected JSONArray getFileOffs(final String nro, final String cod, final int limit) {
        IfaceFilePerform f_iter = new IfaceFilePerform(){

            @Override
            public int filePerform(String filename, Object user_data) throws IOException {
                Object[] pars = (Object[])user_data;
                JSONArray offs = (JSONArray)pars[0];
                int[] qty = (int[])pars[1];
                IfpontoDB db = (IfpontoDB)pars[2];
                if (qty[0] >= limit) {
                    return 1;
                }
                String ref = "_c" + cod + "_n" + nro + "_";
                if (filename.indexOf(ref) < 0) {
                    return 0;
                }
                JSONArray jcontent = Util.loadJSONArrayFile(SIIN.this, filename);
                if (jcontent == null) {
                    return 0;
                }
                IfaceJSONIter j_iter = new IfaceJSONIter(){

                    @Override
                    public int perform(JSONObject off, Object[] pars, int[] count) {
                        JSONArray offs = (JSONArray)pars[0];
                        offs.add((Object)off);
                        int nsr = 0;
                        if (off.containsKey((Object)"nsr") && count[1] < (nsr = Integer.parseInt(off.get((Object)"nsr").toString()))) {
                            count[1] = nsr;
                        }
                        count[0] = count[0] + 1;
                        return 0;
                    }
                };
                qty[0] = qty[0] + 1;
                delete_files.add(filename);
                int[] count = new int[]{0, 0};
                Util.jsonIter(jcontent, j_iter, new Object[]{offs}, count);
                db.updateNsr(cod, "" + count[1]);
                return 0;
            }
        };
        int[] qty = new int[]{0};
        JSONArray offs = new JSONArray();
        FiledirIter dir = new FiledirIter(PATH_OFFS);
        dir.perform(f_iter, OFF_PREFIX, JSON_SUFFIX, new Object[]{offs, qty, this.idb});
        return offs;
    }

    protected JSONArray getStatusDevices(IfpontoDB db, JSONObject jdata) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jdev, Object[] pars, int[] c) {
                if (jdev.get((Object)"ativo").toString().equals("0")) {
                    return 0;
                }
                IfpontoDB db = (IfpontoDB)pars[0];
                JSONArray res = (JSONArray)pars[1];
                String nro = jdev.get((Object)"nro").toString();
                String cod = jdev.get((Object)"codigo").toString();
                JSONObject jstatus = new JSONObject();
                JSONArray jeventos = null;
                try {
                    jstatus = (JSONObject)jdev.get((Object)"status");
                }
                catch (ClassCastException cce) {
                    String msg = "OFFLINE.";
                    SIIN.this.sendMessage(3, msg);
                    jstatus = new JSONObject();
                    SIIN.this.makeStatus(jstatus, msg);
                }
                jstatus.put((Object)"codigo", (Object)cod);
                jstatus.put((Object)"nro", (Object)nro);
                int limit = Integer.parseInt(IfpontoDB.config.get("QTD_OFF_FILES").toString());
                JSONArray jpessoas = db.getNotSyncResults(Integer.parseInt(nro), limit);
                jeventos = SIIN.this.getFileOffs(nro, cod, limit);
                if (jeventos != null) {
                    jstatus.put((Object)"eventos", (Object)jeventos);
                }
                if (jpessoas != null) {
                    jstatus.put((Object)"pessoas", (Object)jpessoas);
                }
                res.add((Object)jstatus);
                return 0;
            }
        };
        JSONArray res = new JSONArray();
        JSONArray devs = db.getDevices();
        if (devs == null) {
            return new JSONArray();
        }
        Util.jsonIter(devs, iter2, new Object[]{db, res}, null);
        if (res == null || res.size() < 1) {
            return res;
        }
        JSONObject dev0 = (JSONObject)res.get(0);
        int limit = Integer.parseInt(IfpontoDB.config.get("QTD_OFF_FILES").toString());
        JSONArray jtemps = db.getNotSyncBios(limit);
        if (jtemps != null && jtemps.size() > 0) {
            dev0.put((Object)"templates", (Object)jtemps);
        }
        return res;
    }

    protected JSONObject processSIIN(final IfpontoDB db) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject dev, Object[] pars, int[] c) {
                SIIN.this.progressPos = 3;
                SIIN.this.notify = "Atualiza eventos sincronizados";
                SIIN.this.notifyProgress();
                SIIN.this.progressPos = 4;
                SIIN.this.notify = "Atualiza pessoas sincronizadas";
                SIIN.this.notifyProgress();
                if (dev.containsKey((Object)"pessoas")) {
                    db.updateSyncResults((JSONArray)dev.get((Object)"pessoas"));
                }
                SIIN.this.progressPos = 5;
                SIIN.this.notify = "Atualiza templates sincronizados";
                SIIN.this.notifyProgress();
                if (dev.containsKey((Object)"templates")) {
                    db.updateSyncBios((JSONArray)dev.get((Object)"templates"));
                }
                return 0;
            }
        };
        long now = new Date().getTime() / 1000L;
        JSONObject jdata = new JSONObject();
        JSONObject jinfo = Util.getInfo(androidContext);
        JSONArray devs = new JSONArray();
        String webhost = IfpontoDB.config.get("WEBHOST");
        String webport = IfpontoDB.config.get("WEBPORT");
        String clientid = IfpontoDB.config.get("CLIENTID");
        String siinpath = IfpontoDB.config.get("SIIN_PATH");
        String id = IfpontoDB.config.get("ID");
        String chave = IfpontoDB.config.get("CHAVE");
        String readers = IfpontoDB.config.get("READERS");
        String key = "";
        jdata.put((Object)"modulo", (Object)"SIIN");
        jdata.put((Object)"versao", (Object)Version.getFormatedText());
        jdata.put((Object)"info", (Object)jinfo);
        jinfo.put((Object)"READERS", (Object)readers);
        jinfo.put((Object)"CHAVE", (Object)chave);
        jinfo.put((Object)"CLIENTID", (Object)clientid);
        jinfo.put((Object)"ID", (Object)id);
        long start = System.currentTimeMillis();
        if (chave == null || chave.equals("")) {
            int i = clientid.indexOf("/");
            key = clientid.substring(i + 1);
        } else {
            devs = this.getStatusDevices(db, jdata);
            jdata.put((Object)"equipamentos", (Object)devs);
            key = String.format("%02X%s%02X", now >> 16 & 0xFFL, chave, now >> 8 & 0xFFL);
        }
        byte[] dados = Util.processRC4(1, key, jdata.toString().getBytes());
        if (dados == null) {
            this.sendMessage(2, "Poss\u00edvel chave inv\u00e1lida: '" + key + "' - verificar CLIENTID");
            return null;
        }
        String[] post = new String[]{"unixtime", "" + now, "dados", Util.byte2base64(dados)};
        String query = clientid + "/db/" + siinpath;
        if (!readers.equals("")) {
            query = query + "?nros=%5B" + readers + "%5D";
        }
        String protocol = "https";
        if (webport.equals("80")) {
            protocol = "http";
        }
        URL url = Util.getURL(protocol, webhost, webport, query);
        this.sendMessage(5, "JSON Request: " + jdata.toString());
        this.sendMessage(5, "HOST: " + url.toString());
        String resp = null;
        JSONObject jresp = null;
        Util.logElapsed(this, "Pacote JSON", start);
        start = System.currentTimeMillis();
        this.progressPos = 2;
        this.notify = "Envia requisi\u00e7\u00e3o ao sistema";
        this.notifyProgress();
        String b64 = Util.sendFORM(this, url, post, 3600);
        if (b64 == null || b64.length() < 1) {
            String msg = "Erro ao tentar acessar servidor.";
            this.sendMessage(1, msg, IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo);
            return null;
        }
        if (b64.charAt(0) == '{') {
            resp = b64;
        } else {
            byte[] cipher = Util.base642byte(b64);
            resp = new String(Util.processRC4(2, key, cipher));
        }
        try {
            JSONParser parser = new JSONParser();
            jresp = (JSONObject)parser.parse(resp);
            Util.jsonIter(devs, iter2, null, null);
        }
        catch (ParseException pe) {
            this.sendMessage(2, "Servidor n\u00e3o est\u00e1 respondendo adequadamente - Verifique o nome do sistema CLIENTID.");
            this.sendMessage(2, "Falha ao tentar abrir JSON:");
            this.sendMessage(2, resp);
        }
        Util.logElapsed(this, "Sincroniza\u00e7\u00e3o ifPonto", start);
        return jresp;
    }

    protected boolean processResponse(IfpontoDB db, JSONObject jdata) {
        if (!jdata.containsKey((Object)"erro")) {
            this.notifyFinalize("Servi\u00e7o Indispon\u00edvel. (1)");
            return false;
        }
        try {
            int err = Integer.parseInt(jdata.get((Object)"erro").toString());
            if (err == 0) {
                this.notifyEnable(IfpontoDB.config.get("CHAVE").toString());
            } else if (err == 1) {
                this.notifyEnable(null);
            }
            if (err != 0) {
                if (jdata.containsKey((Object)"msg")) {
                    this.notifyFinalize(jdata.get((Object)"msg").toString());
                    IfpontoDB.config.put("CHAVE", "");
                    Getopts.saveIniFile(IfpontoDB.config, IfpontoDB.INIFILE);
                } else {
                    this.notifyFinalize("Servi\u00e7o indispon\u00edvel. (2)");
                }
                return false;
            }
            if (jdata.containsKey((Object)"id")) {
                String key = jdata.get((Object)"id").toString();
                IfpontoDB.config.put("CHAVE", key);
                Getopts.saveIniFile(IfpontoDB.config, IfpontoDB.INIFILE);
                this.notifyEnable(key);
                return true;
            }
            if (!jdata.containsKey((Object)"equipamentos")) {
                return true;
            }
            this.progressPos = 7;
            this.notify = "Inicia atualiza\u00e7\u00e3o do banco";
            long start = System.currentTimeMillis();
            this.notifyProgress();
            int n = db.updateDevices((JSONArray)jdata.get((Object)"equipamentos"));
            this.sendMessage(4, "Total equipamentos: " + n);
            Util.logElapsed(this, "Atualiza\u00e7\u00e3o banco", start);
        }
        catch (IOException ioe) {
            this.sendMessage(2, "Falha ao tentar salvar: " + IfpontoDB.INIFILE);
        }
        catch (NumberFormatException nfe) {
            this.sendMessage(2, "Erro interno.");
            return false;
        }
        return true;
    }

    public static String statusDB(IfpontoDB db) {
        final IfaceJSONIter iterevt = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jevt, Object[] pars, int[] count) {
                StringBuffer sb = (StringBuffer)pars[0];
                if (jevt.containsKey((Object)"total")) {
                    sb.append(String.format("total: %s    ", jevt.get((Object)"total").toString()));
                }
                if (jevt.containsKey((Object)"sincronizado") && jevt.get((Object)"sincronizado") != null) {
                    sb.append(String.format("status: %s   \r\n", jevt.get((Object)"sincronizado").toString()));
                }
                sb.append("########################################################################################\n");
                return 0;
            }
        };
        final IfaceJSONIter iterep = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jep, Object[] pars, int[] count) {
                StringBuffer sb = (StringBuffer)pars[0];
                if (jep.containsKey((Object)"pis")) {
                    sb.append(String.format("%s   ", jep.get((Object)"pis").toString()));
                }
                if (jep.containsKey((Object)"situacao")) {
                    sb.append(String.format("%-20s   ", jep.get((Object)"situacao").toString()));
                }
                if (jep.containsKey((Object)"nome")) {
                    sb.append(String.format("%s\r\n", jep.get((Object)"nome").toString()));
                }
                return 0;
            }
        };
        final IfaceJSONIter iterev = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jevt, Object[] pars, int[] count) {
                StringBuffer sb = (StringBuffer)pars[0];
                if (jevt.containsKey((Object)"nsr") && jevt.get((Object)"nsr") != null) {
                    sb.append(String.format("NSR: %s    ", jevt.get((Object)"nsr").toString()));
                }
                if (jevt.containsKey((Object)"dtcadastro")) {
                    sb.append(String.format("ultima atualizacao: %s    ", jevt.get((Object)"dtcadastro").toString()));
                }
                if (jevt.containsKey((Object)"datahora") && jevt.get((Object)"sincronizado") != null) {
                    sb.append(String.format("ultimo evento: %s\r\n", jevt.get((Object)"datahora").toString()));
                }
                return 0;
            }
        };
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jeq, Object[] pars, int[] count) {
                StringBuffer sb = (StringBuffer)pars[0];
                sb.append("########################################################################################\n");
                sb.append(String.format("%s - ", jeq.get((Object)"numero").toString()));
                sb.append(String.format("%s\r\n", jeq.get((Object)"nome").toString()));
                Util.jsonIter((JSONArray)jeq.get((Object)"evento_total"), iterev, new Object[]{sb}, null);
                Util.jsonIter((JSONArray)jeq.get((Object)"sincronizado_total"), iterevt, new Object[]{sb}, null);
                Util.jsonIter((JSONArray)jeq.get((Object)"pessoas"), iterep, new Object[]{sb}, null);
                sb.append("\r\r\n\n");
                return 0;
            }
        };
        if (db == null) {
            db = new IfpontoDB(new String[0], null);
            db.init(new String[0], SIINServer.server);
            db.open(null, SIINServer.server);
        }
        JSONObject jres = db.statusDB();
        db.close();
        StringBuffer sb = new StringBuffer();
        Util.jsonIter((JSONArray)jres.get((Object)"equipamentos"), iter2, new Object[]{sb}, null);
        Date dt = new Date();
        String fileresult = Device.path_log + File.separator + "statusDB.txt";
        try {
            FileWriter file = new FileWriter(fileresult);
            if (sb.toString().length() != 0) {
                file.write(dt.toString() + "\n\n" + sb.toString());
            } else {
                file.write("Banco de dados est\u00e1 vazio.");
            }
            file.flush();
            file.close();
        }
        catch (IOException e) {
            System.err.println("Falha ao tentar criar o arquivo: " + fileresult);
        }
        return "";
    }

    private Object parseFile(Producer prod, String filename, String[] cod_nro) {
        File f = new File(filename);
        String[] tk = f.getName().split("_[cn]?");
        if (tk.length < 3) {
            return null;
        }
        Object json = Util.loadJSONFile(prod, filename);
        if (json == null) {
            return null;
        }
        cod_nro[0] = tk[1];
        cod_nro[1] = tk[2];
        prod.sendMessage(5, "Process: " + filename);
        return json;
    }

    @Override
    public void run() {
        alive = true;
        this.notifyLoop(alive);
        if (this.observers.length < 2) {
            this.addObserver(this);
        }
        while (alive) {
            this.progressPos = 1;
            this.notify = "Inicia loop";
            this.notifyProgress();
            JSONObject jdata = this.processSIIN(this.idb);
            if (jdata != null) {
                this.sendMessage(5, "Resp: " + jdata.toString());
                this.sendMessage(5, "Marca todos os equipamentos como inativos.");
                this.idb.disableDevices();
                this.progressPos = 6;
                this.notify = "Processando resposta do sistema";
                this.notifyProgress();
                boolean r = this.processResponse(this.idb, jdata);
                if (r) {
                    this.notifyFinalize(null);
                } else {
                    this.notifyFinalize("Falha sincroniza\u00e7\u00e3o.");
                }
                for (String e : delete_files) {
                    new File(e).delete();
                }
            } else {
                this.notifyFinalize("Falha comunica\u00e7\u00e3o com o sistema.");
            }
            delete_files.clear();
            String[][] prefix_title = new String[][]{{RESULT_PREFIX, "Process Result"}, {ACESSO_PREFIX, "Process Acesso"}, {USER_PREFIX, "Process Rollback"}, {STATUS_PREFIX, "Device Status"}};
            FiledirIter dir = new FiledirIter(PATH_OFFS);
            long start = 0L;
            for (String[] pair : prefix_title) {
                start = System.currentTimeMillis();
                dir.perform(this.processFileIter, pair[0], JSON_SUFFIX, new Object[]{this});
                Util.logElapsed(this, pair[1], start);
            }
            start = System.currentTimeMillis();
            Util.logElapsed(this, "Status", start);
            start = System.currentTimeMillis();
            this.notifyIdle();
            Util.logElapsed(this, "Idle", start);
            this.progressPos = 0;
            this.notify = "Fim do loop";
            this.notifyProgress();
        }
        this.notifyLoop(alive);
    }

    public <T> Thread call(T ctx, ConcurrentListener<T> cl, String[] args) {
        Thread th = this.concurrentCall(ctx, cl, args);
        return th;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void startSIINLoop() {
        if (thread != null && thread.isAlive()) {
            return;
        }
        thread = new Thread((Runnable)this, "SIIN");
        thread.start();
    }

    public void stopSIINLoop() {
        alive = false;
    }

    public static final JSONObject getInfo(String modulo, HashMap<String, String> conf, Object androidContext) {
        String[] keys;
        JSONObject jdata = new JSONObject();
        JSONObject jinfo = Util.getInfo(androidContext);
        for (String key : keys = new String[]{"READERS", "CHAVE", "CLIENTID", "ID"}) {
            if (!conf.containsKey(key)) continue;
            jdata.put((Object)key, (Object)conf.get(key));
        }
        jdata.put((Object)"modulo", (Object)modulo);
        jdata.put((Object)"versao", (Object)Version.getFormatedText());
        jdata.put((Object)"info", (Object)jinfo);
        return jdata;
    }

    public static void main(String[] args) {
        IfpontoDB db = new IfpontoDB(args, null);
        db.init(new String[0], null);
        db.open(null);
        SIIN siin = SIIN.getInstance(args, db, null);
        siin.getFileOffs("200", "6", 10);
    }
}

