/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.ClientListener;
import com.ifractal.ifponto.SIINServer;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Peer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelClientListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SIINClient<T>
extends Producer
implements TunnelClientListener<T> {
    public static final long timeout = 0L;
    protected final ClientListener<T> clientListener;
    protected JSONObject profile = null;
    protected TunnelPeer<T> peer = null;
    protected String chave = "";
    protected String id = "";
    protected T client;

    public SIINClient(ClientListener<T> sl, T ctx) {
        super(sl);
        this.clientListener = sl;
        this.client = ctx;
    }

    public void connectTunnel() {
        this.connectTunnel(SIINServer.tunnelHost, SIINServer.tunnelPort);
    }

    public void connectTunnel(String host, int port) {
        Peer.connect(this.client, this, host, port, 0L);
    }

    public boolean connect(JSONObject server, Object androidContext, T ctx) {
        String[] keys;
        if (server == null || this.peer == null || !server.containsKey((Object)"access") || !server.containsKey((Object)"info")) {
            return false;
        }
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            private boolean isValidIP(String ip) {
                String[] ignore;
                for (String i : ignore = new String[]{"", "127.0.0.1", "0.0.0.0"}) {
                    if (!ip.equals(i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int perform(JSONObject iface, Object[] pars, int[] count) {
                String[] ips = (String[])pars[0];
                if (!iface.containsKey((Object)"ip")) {
                    return 0;
                }
                String ip = iface.get((Object)"ip").toString();
                if (!this.isValidIP(ip)) {
                    return 0;
                }
                ips[count[0]] = ip;
                count[0] = count[0] + 1;
                return 0;
            }
        };
        String access = server.get((Object)"access").toString();
        JSONObject info = (JSONObject)server.get((Object)"info");
        for (String k : keys = new String[]{"id", "port", "ifaces"}) {
            if (info.containsKey((Object)k)) continue;
            this.sendMessage(3, "info SIINServer incompleta - key: " + k);
            return false;
        }
        String id = info.get((Object)"id").toString();
        int port = SIINServer.localPort;
        if (access.equals("tunnel")) {
            String[] msg = new String[]{"match", id};
            this.peer.send(msg);
            return true;
        }
        try {
            port = Integer.parseInt(info.get((Object)"port").toString());
        }
        catch (NumberFormatException nfe) {
            this.sendMessage(3, "porta do modulo n\u00e3o informada...");
            return false;
        }
        JSONObject self = Util.getInfo(androidContext);
        JSONArray self_ifaces = (JSONArray)self.get((Object)"ifaces");
        String[] self_ips = new String[self_ifaces.size()];
        JSONArray serv_ifaces = (JSONArray)info.get((Object)"ifaces");
        String[] serv_ips = new String[serv_ifaces.size()];
        int[] c = new int[]{0};
        Util.jsonIter(self_ifaces, iter2, new Object[]{self_ips}, c);
        c[0] = 0;
        Util.jsonIter(serv_ifaces, iter2, new Object[]{serv_ips}, c);
        String ip = null;
        for (String serv_ip : serv_ips) {
            if (serv_ip == null) continue;
            ip = serv_ip;
            for (String self_ip : self_ips) {
                if (self_ip == null || !self_ip.equals(serv_ip)) continue;
                return false;
            }
        }
        if (ip == null) {
            return false;
        }
        this.client = ctx;
        Peer.connect(ctx, this, ip, port, 0L);
        return true;
    }

    public void connect(int port) {
        Peer.connect(this.client, this, "127.0.0.1", port, 0L);
    }

    public void startSIINLoop() {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "startSIINLoop"};
        int r = this.peer.send(cmd);
        if (r < 0) {
            this.sendMessage(2, "startSIINLoop error: " + r);
        }
    }

    public void stopSIINLoop() {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "stopSIINLoop"};
        this.peer.send(cmd);
    }

    public void call(String[] args) {
        if (this.peer == null) {
            return;
        }
    }

    public void startAllDevices() {
        if (this.peer == null) {
            return;
        }
    }

    public void stopAllDevices() {
        if (this.peer == null) {
            return;
        }
    }

    public void getDBUsers(String nro) {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "getDBUsers", "String", nro};
        this.peer.send(cmd);
    }

    public void getDBEvents(String nro, int limit) {
        if (this.peer == null) {
            return;
        }
    }

    public void getDBDevices() {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "getDBDevices"};
        this.peer.send(cmd);
    }

    public void getDBPendingUsers(String codigo) {
        if (this.peer == null) {
            return;
        }
    }

    public void startDevice(int codigo, int startNsr) {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "startDevice", "int", "" + codigo, "int", "" + startNsr};
        this.peer.send(cmd);
    }

    public void stopDevice(int codigo) {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "stopDevice", "int", "" + codigo};
        this.peer.send(cmd);
    }

    public void getDeviceUsers(String codigo) {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "getDeviceUsers", "String", codigo};
        this.peer.send(cmd);
    }

    public void setVerbosity(int level) {
        if (this.peer == null) {
            return;
        }
        String[] cmd = new String[]{"method", "setVerbosity", "int", "" + level};
        this.peer.send(cmd);
    }

    @Override
    public void onConnect(T ctx, TunnelPeer<T> p) {
        this.peer = p;
        String[] args = new String[]{"CHAVE", ctx.toString()};
        this.peer.sendObserverInfo(args);
        this.clientListener.onConnect(this, ctx, this.peer);
    }

    @Override
    public void onMessage(T ctx, TunnelServer<T> ts, TunnelPeer<T> peer, String[] msg) {
        JSONArray jservers = (JSONArray)Util.getJSONFromArgs(msg, "servers");
        if (jservers != null) {
            this.clientListener.onAvailable(this, this.client, jservers);
            return;
        }
        String response = Util.getValueFromArgs(msg, "onResponse");
        if (response != null) {
            this.clientListener.onResponse(this, this.client, msg);
            return;
        }
        String event = Util.getValueFromArgs(msg, "broadcast");
        if (event == null) {
            this.clientListener.onMessage(this, this.client, 3, "Mensagem nao tratada...");
            return;
        }
        if (event.equals("onMessage")) {
            this.handleMessage(msg);
        }
        this.handleBroadcast(event, msg);
    }

    protected boolean handleBroadcast(String ev, String[] msg) {
        String[][] keys;
        for (String[] e : keys = new String[][]{{"onStart"}, {"onStop"}, {"onGetTime", "date"}, {"onSetTime", "timediff"}, {"onSendUser", "user", "result", "pos", "total"}, {"onEvents", "offs"}, {"onFinalize", "online", "users", "result"}, {"onEnable", "key"}, {"onFail", "message"}, {"onSynchronized"}, {"onProgress", "progressTotal", "progressPos", "notify"}}) {
            if (e.length < 2 || !e[0].equals(ev)) continue;
            int len = e.length - 1;
            String[] pars = new String[len];
            System.arraycopy(e, 1, pars, 0, len);
            if (Util.checkKeysInArgs(msg, pars)) continue;
            this.clientListener.onMessage(this, this.client, 2, "Faltam parametros: " + ev);
            return false;
        }
        JSONObject jdev = (JSONObject)Util.getJSONFromArgs(msg, "device");
        if (ev.equals("onStart")) {
            if (jdev == null) {
                this.clientListener.onStart(this, this.client);
            } else {
                this.clientListener.onStart(this, this.client, jdev);
            }
        } else if (ev.equals("onStop")) {
            if (jdev == null) {
                this.clientListener.onStop(this, this.client);
            } else {
                this.clientListener.onStop(this, this.client, jdev);
            }
        } else if (ev.equals("onEnable")) {
            String key = Util.getValueFromArgs(msg, "key");
            this.clientListener.onEnable(this, this.client, key);
        } else if (ev.equals("onFail")) {
            String message = Util.getValueFromArgs(msg, "message");
            this.clientListener.onFail(this, this.client, message);
        } else if (ev.equals("onSynchronized")) {
            this.clientListener.onSynchronized(this, this.client);
        } else if (ev.equals("onProgress")) {
            int progressTotal = Integer.parseInt(Util.getValueFromArgs(msg, "progressTotal"));
            int progressPos = Integer.parseInt(Util.getValueFromArgs(msg, "progressPos"));
            String notify = Util.getValueFromArgs(msg, "notify");
            this.clientListener.onProgress(this, this.client, progressTotal, progressPos, notify);
        }
        if (jdev == null) {
            return true;
        }
        if (ev.equals("onGetTime")) {
            Date dt;
            String strdt = Util.getValueFromArgs(msg, "date");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                dt = fmt.parse(strdt);
            }
            catch (ParseException pe) {
                this.clientListener.onMessage(this, this.client, 2, ev + " - data invalida: " + strdt);
                return false;
            }
            this.clientListener.onGetTime(this, this.client, jdev, dt);
        } else if (ev.equals("onSetTime")) {
            int diff = Util.getIntFromArgs(msg, "timediff");
            this.clientListener.onSetTime(this, this.client, jdev, diff);
        } else if (ev.equals("onSendUser")) {
            JSONObject juser = (JSONObject)Util.getJSONFromArgs(msg, "user");
            JSONObject jres = (JSONObject)Util.getJSONFromArgs(msg, "result");
            int total = Util.getIntFromArgs(msg, "total");
            int pos = Util.getIntFromArgs(msg, "pos");
            if (juser == null || jres == null) {
                this.clientListener.onMessage(this, this.client, 2, ev + ": JSON invalido.");
                return false;
            }
            this.clientListener.onSendUser(this, this.client, jdev, juser, jres, pos, total);
        } else if (ev.equals("onGetBio")) {
            JSONObject juserBios = (JSONObject)Util.getJSONFromArgs(msg, "userBios");
            int total = Util.getIntFromArgs(msg, "total");
            int pos = Util.getIntFromArgs(msg, "pos");
            if (juserBios == null) {
                this.clientListener.onMessage(this, this.client, 2, ev + ": JSON invalido.");
                return false;
            }
            this.clientListener.onGetBio(this, this.client, jdev, juserBios, pos, total);
        } else if (ev.equals("onEvents")) {
            JSONArray joffs = (JSONArray)Util.getJSONFromArgs(msg, "offs");
            if (joffs == null) {
                this.clientListener.onMessage(this, this.client, 2, ev + ": JSON invalido.");
                return false;
            }
            this.clientListener.onEvents(this, this.client, jdev, joffs);
        } else if (ev.equals("onFinalize")) {
            String on = Util.getValueFromArgs(msg, "online");
            JSONArray jusers = (JSONArray)Util.getJSONFromArgs(msg, "users");
            JSONArray jres = (JSONArray)Util.getJSONFromArgs(msg, "result");
            boolean online = true;
            if (on.equals("false")) {
                online = false;
            }
            if (jusers == null || jres == null) {
                this.clientListener.onMessage(this, this.client, 2, ev + ": JSON invalido.");
                return false;
            }
            this.clientListener.onFinalize(this, this.client, jdev, online, jusers, jres);
        }
        return true;
    }

    protected boolean handleMessage(String[] msg) {
        String[] keys = new String[]{"class", "verbosity", "message", "code"};
        if (!Util.checkKeysInArgs(msg, keys)) {
            this.clientListener.onMessage(this, this.client, 3, "Mensagem inconsistente: 'onMessage'");
            return false;
        }
        String klass = Util.getValueFromArgs(msg, "class");
        String content = klass + "|" + Util.getValueFromArgs(msg, "message");
        int level = Verbosity.getLevel(Util.getValueFromArgs(msg, "verbosity"));
        int code = 0;
        try {
            code = Integer.parseInt(Util.getValueFromArgs(msg, "code"));
        }
        catch (NumberFormatException nfe) {
            this.clientListener.onMessage(this, this.client, 3, "Mensagem inconsistente: code not a number.");
            return false;
        }
        this.clientListener.onMessage(this, this.client, level, content, code);
        return true;
    }
}

