/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.IntRect;

class BlockGrid {
    final IntPoint blocks;
    final IntPoint corners;
    final int[] x;
    final int[] y;

    BlockGrid(IntPoint size) {
        this.blocks = size;
        this.corners = new IntPoint(size.x + 1, size.y + 1);
        this.x = new int[size.x + 1];
        this.y = new int[size.y + 1];
    }

    BlockGrid(int width, int height) {
        this(new IntPoint(width, height));
    }

    IntPoint corner(int atX, int atY) {
        return new IntPoint(this.x[atX], this.y[atY]);
    }

    IntPoint corner(IntPoint at) {
        return this.corner(at.x, at.y);
    }

    IntRect block(int atX, int atY) {
        return IntRect.between(this.corner(atX, atY), this.corner(atX + 1, atY + 1));
    }

    IntRect block(IntPoint at) {
        return this.block(at.x, at.y);
    }
}

