/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;

class BooleanMatrix {
    final int width;
    final int height;
    private final boolean[] cells;

    BooleanMatrix(int width, int height) {
        this.width = width;
        this.height = height;
        this.cells = new boolean[width * height];
    }

    BooleanMatrix(IntPoint size) {
        this(size.x, size.y);
    }

    BooleanMatrix(BooleanMatrix other) {
        this(other.size());
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = other.cells[i];
        }
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    boolean get(int x, int y) {
        return this.cells[this.offset(x, y)];
    }

    boolean get(IntPoint at) {
        return this.get(at.x, at.y);
    }

    boolean get(int x, int y, boolean fallback) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return fallback;
        }
        return this.cells[this.offset(x, y)];
    }

    boolean get(IntPoint at, boolean fallback) {
        return this.get(at.x, at.y, fallback);
    }

    void set(int x, int y, boolean value) {
        this.cells[this.offset((int)x, (int)y)] = value;
    }

    void set(IntPoint at, boolean value) {
        this.set(at.x, at.y, value);
    }

    void invert() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = !this.cells[i];
        }
    }

    void merge(BooleanMatrix other) {
        if (other.width != this.width || other.height != this.height) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.cells.length; ++i) {
            int n = i;
            this.cells[n] = this.cells[n] | other.cells[i];
        }
    }

    private int offset(int x, int y) {
        return y * this.width + x;
    }
}

