/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;

class DoubleMatrix {
    final int width;
    final int height;
    private final double[] cells;

    DoubleMatrix(int width, int height) {
        this.width = width;
        this.height = height;
        this.cells = new double[width * height];
    }

    DoubleMatrix(IntPoint size) {
        this(size.x, size.y);
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    double get(int x, int y) {
        return this.cells[this.offset(x, y)];
    }

    double get(IntPoint at) {
        return this.get(at.x, at.y);
    }

    void set(int x, int y, double value) {
        this.cells[this.offset((int)x, (int)y)] = value;
    }

    void set(IntPoint at, double value) {
        this.set(at.x, at.y, value);
    }

    void add(int x, int y, double value) {
        int n = this.offset(x, y);
        this.cells[n] = this.cells[n] + value;
    }

    void add(IntPoint at, double value) {
        this.add(at.x, at.y, value);
    }

    void multiply(int x, int y, double value) {
        int n = this.offset(x, y);
        this.cells[n] = this.cells[n] * value;
    }

    void multiply(IntPoint at, double value) {
        this.multiply(at.x, at.y, value);
    }

    private int offset(int x, int y) {
        return y * this.width + x;
    }
}

