/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.ImmutableMinutia;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.Integers;

class EdgeShape {
    private static final int POLAR_CACHE_BITS = 8;
    private static final int POLAR_CACHE_RADIUS = 256;
    private static final int[] POLAR_DISTANCE_CACHE = new int[Integers.sq(256)];
    private static final double[] POLAR_ANGLE_CACHE = new double[Integers.sq(256)];
    final int length;
    final double referenceAngle;
    final double neighborAngle;

    EdgeShape(int length, double referenceAngle, double neighborAngle) {
        this.length = length;
        this.referenceAngle = referenceAngle;
        this.neighborAngle = neighborAngle;
    }

    EdgeShape(ImmutableMinutia reference, ImmutableMinutia neighbor) {
        IntPoint vector = neighbor.position.minus(reference.position);
        double quadrant = 0.0;
        int x = vector.x;
        int y = vector.y;
        if (y < 0) {
            x = -x;
            y = -y;
            quadrant = Math.PI;
        }
        if (x < 0) {
            int tmp = -x;
            x = y;
            y = tmp;
            quadrant += 1.5707963267948966;
        }
        int shift = 32 - Integer.numberOfLeadingZeros((x | y) >>> 8);
        int offset = (y >> shift) * 256 + (x >> shift);
        this.length = POLAR_DISTANCE_CACHE[offset] << shift;
        double angle = POLAR_ANGLE_CACHE[offset] + quadrant;
        this.referenceAngle = DoubleAngle.difference(reference.direction, angle);
        this.neighborAngle = DoubleAngle.difference(neighbor.direction, DoubleAngle.opposite(angle));
    }

    static {
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                EdgeShape.POLAR_DISTANCE_CACHE[y * 256 + x] = (int)Math.round(Math.sqrt(Integers.sq(x) + Integers.sq(y)));
                EdgeShape.POLAR_ANGLE_CACHE[y * 256 + x] = y > 0 || x > 0 ? DoubleAngle.atan(new DoublePoint(x, y)) : 0.0;
            }
        }
    }
}

