/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.BlockMap;
import com.machinezoo.sourceafis.BooleanMatrix;
import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.DoubleMatrix;
import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.DoublePointMatrix;
import com.machinezoo.sourceafis.Doubles;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.HistogramCube;
import com.machinezoo.sourceafis.IntMatrix;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.IntRange;
import com.machinezoo.sourceafis.IntRect;
import com.machinezoo.sourceafis.Integers;
import com.machinezoo.sourceafis.MinutiaType;
import com.machinezoo.sourceafis.MutableMinutia;
import com.machinezoo.sourceafis.MutableTemplate;
import com.machinezoo.sourceafis.Skeleton;
import com.machinezoo.sourceafis.SkeletonMinutia;
import com.machinezoo.sourceafis.SkeletonType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class FeatureExtractor {
    FeatureExtractor() {
    }

    static MutableTemplate extract(DoubleMatrix raw, double dpi) {
        MutableTemplate template = new MutableTemplate();
        FingerprintTransparency.current().log("decoded-image", raw);
        if (Math.abs(dpi - 500.0) > 5.0) {
            raw = FeatureExtractor.scaleImage(raw, dpi);
        }
        FingerprintTransparency.current().log("scaled-image", raw);
        template.size = raw.size();
        BlockMap blocks = new BlockMap(raw.width, raw.height, 15);
        FingerprintTransparency.current().log("blocks", blocks);
        HistogramCube histogram = FeatureExtractor.histogram(blocks, raw);
        HistogramCube smoothHistogram = FeatureExtractor.smoothHistogram(blocks, histogram);
        BooleanMatrix mask = FeatureExtractor.mask(blocks, histogram);
        DoubleMatrix equalized = FeatureExtractor.equalize(blocks, raw, smoothHistogram, mask);
        DoubleMatrix orientation = FeatureExtractor.orientationMap(equalized, mask, blocks);
        IntPoint[][] smoothedLines = FeatureExtractor.orientedLines(32, 7, 1.59);
        DoubleMatrix smoothed = FeatureExtractor.smoothRidges(equalized, orientation, mask, blocks, 0.0, smoothedLines);
        FingerprintTransparency.current().log("parallel-smoothing", smoothed);
        IntPoint[][] orthogonalLines = FeatureExtractor.orientedLines(11, 4, 1.11);
        DoubleMatrix orthogonal = FeatureExtractor.smoothRidges(smoothed, orientation, mask, blocks, Math.PI, orthogonalLines);
        FingerprintTransparency.current().log("orthogonal-smoothing", orthogonal);
        BooleanMatrix binary = FeatureExtractor.binarize(smoothed, orthogonal, mask, blocks);
        BooleanMatrix pixelMask = FeatureExtractor.fillBlocks(mask, blocks);
        FeatureExtractor.cleanupBinarized(binary, pixelMask);
        FingerprintTransparency.current().log("pixel-mask", pixelMask);
        BooleanMatrix inverted = FeatureExtractor.invert(binary, pixelMask);
        BooleanMatrix innerMask = FeatureExtractor.innerMask(pixelMask);
        Skeleton ridges = new Skeleton(binary, SkeletonType.RIDGES);
        Skeleton valleys = new Skeleton(inverted, SkeletonType.VALLEYS);
        template.minutiae = new ArrayList<MutableMinutia>();
        FeatureExtractor.collectMinutiae(template.minutiae, ridges, MinutiaType.ENDING);
        FeatureExtractor.collectMinutiae(template.minutiae, valleys, MinutiaType.BIFURCATION);
        FingerprintTransparency.current().log("skeleton-minutiae", template);
        FeatureExtractor.maskMinutiae(template.minutiae, innerMask);
        FingerprintTransparency.current().log("inner-minutiae", template);
        FeatureExtractor.removeMinutiaClouds(template.minutiae);
        FingerprintTransparency.current().log("removed-minutia-clouds", template);
        template.minutiae = FeatureExtractor.limitTemplateSize(template.minutiae);
        FingerprintTransparency.current().log("top-minutiae", template);
        return template;
    }

    static DoubleMatrix scaleImage(DoubleMatrix input, double dpi) {
        return FeatureExtractor.scaleImage(input, (int)Math.round(500.0 / dpi * (double)input.width), (int)Math.round(500.0 / dpi * (double)input.height));
    }

    static DoubleMatrix scaleImage(DoubleMatrix input, int newWidth, int newHeight) {
        DoubleMatrix output = new DoubleMatrix(newWidth, newHeight);
        double scaleX = (double)newWidth / (double)input.width;
        double scaleY = (double)newHeight / (double)input.height;
        double descaleX = 1.0 / scaleX;
        double descaleY = 1.0 / scaleY;
        for (int y = 0; y < newHeight; ++y) {
            double y1 = (double)y * descaleY;
            double y2 = y1 + descaleY;
            int y1i = (int)y1;
            int y2i = Math.min((int)Math.ceil(y2), input.height);
            for (int x = 0; x < newWidth; ++x) {
                double x1 = (double)x * descaleX;
                double x2 = x1 + descaleX;
                int x1i = (int)x1;
                int x2i = Math.min((int)Math.ceil(x2), input.width);
                double sum = 0.0;
                for (int oy = y1i; oy < y2i; ++oy) {
                    double ry = Math.min((double)(oy + 1), y2) - Math.max((double)oy, y1);
                    for (int ox = x1i; ox < x2i; ++ox) {
                        double rx = Math.min((double)(ox + 1), x2) - Math.max((double)ox, x1);
                        sum += rx * ry * input.get(ox, oy);
                    }
                }
                output.set(x, y, sum * (scaleX * scaleY));
            }
        }
        return output;
    }

    private static HistogramCube histogram(BlockMap blocks, DoubleMatrix image) {
        HistogramCube histogram = new HistogramCube(blocks.primary.blocks, 256);
        for (IntPoint block : blocks.primary.blocks) {
            IntRect area = blocks.primary.block(block);
            for (int y = area.top(); y < area.bottom(); ++y) {
                for (int x = area.left(); x < area.right(); ++x) {
                    int depth = (int)(image.get(x, y) * (double)histogram.bins);
                    histogram.increment(block, histogram.constrain(depth));
                }
            }
        }
        FingerprintTransparency.current().log("histogram", histogram);
        return histogram;
    }

    private static HistogramCube smoothHistogram(BlockMap blocks, HistogramCube input) {
        IntPoint[] blocksAround = new IntPoint[]{new IntPoint(0, 0), new IntPoint(-1, 0), new IntPoint(0, -1), new IntPoint(-1, -1)};
        HistogramCube output = new HistogramCube(blocks.secondary.blocks, input.bins);
        for (IntPoint corner : blocks.secondary.blocks) {
            for (IntPoint relative : blocksAround) {
                IntPoint block = corner.plus(relative);
                if (!blocks.primary.blocks.contains(block)) continue;
                for (int i = 0; i < input.bins; ++i) {
                    output.add(corner, i, input.get(block, i));
                }
            }
        }
        FingerprintTransparency.current().log("smoothed-histogram", output);
        return output;
    }

    private static BooleanMatrix mask(BlockMap blocks, HistogramCube histogram) {
        DoubleMatrix contrast = FeatureExtractor.clipContrast(blocks, histogram);
        BooleanMatrix mask = FeatureExtractor.filterAbsoluteContrast(contrast);
        mask.merge(FeatureExtractor.filterRelativeContrast(contrast, blocks));
        FingerprintTransparency.current().log("combined-mask", mask);
        mask.merge(FeatureExtractor.filterBlockErrors(mask));
        mask.invert();
        mask.merge(FeatureExtractor.filterBlockErrors(mask));
        mask.merge(FeatureExtractor.filterBlockErrors(mask));
        mask.merge(FeatureExtractor.vote(mask, null, 7, 0.51, 4));
        FingerprintTransparency.current().log("filtered-mask", mask);
        return mask;
    }

    private static DoubleMatrix clipContrast(BlockMap blocks, HistogramCube histogram) {
        DoubleMatrix result = new DoubleMatrix(blocks.primary.blocks);
        for (IntPoint block : blocks.primary.blocks) {
            int volume = histogram.sum(block);
            int clipLimit = (int)Math.round((double)volume * 0.08);
            int accumulator = 0;
            int lowerBound = histogram.bins - 1;
            for (int i = 0; i < histogram.bins; ++i) {
                if ((accumulator += histogram.get(block, i)) <= clipLimit) continue;
                lowerBound = i;
                break;
            }
            accumulator = 0;
            int upperBound = 0;
            for (int i = histogram.bins - 1; i >= 0; --i) {
                if ((accumulator += histogram.get(block, i)) <= clipLimit) continue;
                upperBound = i;
                break;
            }
            result.set(block, (double)(upperBound - lowerBound) * (1.0 / (double)(histogram.bins - 1)));
        }
        FingerprintTransparency.current().log("contrast", result);
        return result;
    }

    private static BooleanMatrix filterAbsoluteContrast(DoubleMatrix contrast) {
        BooleanMatrix result = new BooleanMatrix(contrast.size());
        for (IntPoint block : contrast.size()) {
            if (!(contrast.get(block) < 0.06666666666666667)) continue;
            result.set(block, true);
        }
        FingerprintTransparency.current().log("absolute-contrast-mask", result);
        return result;
    }

    private static BooleanMatrix filterRelativeContrast(DoubleMatrix contrast, BlockMap blocks) {
        ArrayList<Double> sortedContrast = new ArrayList<Double>();
        for (IntPoint block : contrast.size()) {
            sortedContrast.add(contrast.get(block));
        }
        sortedContrast.sort(Comparator.naturalOrder().reversed());
        int pixelsPerBlock = blocks.pixels.area() / blocks.primary.blocks.area();
        int sampleCount = Math.min(sortedContrast.size(), 168568 / pixelsPerBlock);
        int consideredBlocks = Math.max((int)Math.round((double)sampleCount * 0.49), 1);
        double averageContrast = sortedContrast.stream().mapToDouble(n -> n).limit(consideredBlocks).average().getAsDouble();
        double limit = averageContrast * 0.34;
        BooleanMatrix result = new BooleanMatrix(blocks.primary.blocks);
        for (IntPoint block : blocks.primary.blocks) {
            if (!(contrast.get(block) < limit)) continue;
            result.set(block, true);
        }
        FingerprintTransparency.current().log("relative-contrast-mask", result);
        return result;
    }

    private static BooleanMatrix vote(BooleanMatrix input, BooleanMatrix mask, int radius, double majority, int borderDistance) {
        IntPoint size = input.size();
        IntRect rect = new IntRect(borderDistance, borderDistance, size.x - 2 * borderDistance, size.y - 2 * borderDistance);
        int[] thresholds = IntStream.range(0, Integers.sq(2 * radius + 1) + 1).map(i -> (int)Math.ceil(majority * (double)i)).toArray();
        IntMatrix counts = new IntMatrix(size);
        BooleanMatrix output = new BooleanMatrix(size);
        for (int y = rect.top(); y < rect.bottom(); ++y) {
            int superTop = y - radius - 1;
            int superBottom = y + radius;
            int yMin = Math.max(0, y - radius);
            int yMax = Math.min(size.y - 1, y + radius);
            int yRange = yMax - yMin + 1;
            for (int x = rect.left(); x < rect.right(); ++x) {
                int ones;
                if (mask != null && !mask.get(x, y)) continue;
                int left = x > 0 ? counts.get(x - 1, y) : 0;
                int top = y > 0 ? counts.get(x, y - 1) : 0;
                int diagonal = x > 0 && y > 0 ? counts.get(x - 1, y - 1) : 0;
                int xMin = Math.max(0, x - radius);
                int xMax = Math.min(size.x - 1, x + radius);
                if (left > 0 && top > 0 && diagonal > 0) {
                    ones = top + left - diagonal - 1;
                    int superLeft = x - radius - 1;
                    int superRight = x + radius;
                    if (superLeft >= 0 && superTop >= 0 && input.get(superLeft, superTop)) {
                        ++ones;
                    }
                    if (superLeft >= 0 && superBottom < size.y && input.get(superLeft, superBottom)) {
                        --ones;
                    }
                    if (superRight < size.x && superTop >= 0 && input.get(superRight, superTop)) {
                        --ones;
                    }
                    if (superRight < size.x && superBottom < size.y && input.get(superRight, superBottom)) {
                        ++ones;
                    }
                } else {
                    ones = 0;
                    for (int ny = yMin; ny <= yMax; ++ny) {
                        for (int nx = xMin; nx <= xMax; ++nx) {
                            if (!input.get(nx, ny)) continue;
                            ++ones;
                        }
                    }
                }
                counts.set(x, y, ones + 1);
                if (ones < thresholds[yRange * (xMax - xMin + 1)]) continue;
                output.set(x, y, true);
            }
        }
        return output;
    }

    private static BooleanMatrix filterBlockErrors(BooleanMatrix input) {
        return FeatureExtractor.vote(input, null, 1, 0.7, 4);
    }

    private static DoubleMatrix equalize(BlockMap blocks, DoubleMatrix image, HistogramCube histogram, BooleanMatrix blockMask) {
        double rangeMin = -1.0;
        double rangeMax = 1.0;
        double rangeSize = 2.0;
        double widthMax = 0.031171875;
        double widthMin = 0.001953125;
        double[] limitedMin = new double[histogram.bins];
        double[] limitedMax = new double[histogram.bins];
        double[] dequantized = new double[histogram.bins];
        for (int i = 0; i < histogram.bins; ++i) {
            limitedMin[i] = Math.max((double)i * 0.001953125 + -1.0, 1.0 - (double)(histogram.bins - 1 - i) * 0.031171875);
            limitedMax[i] = Math.min((double)i * 0.031171875 + -1.0, 1.0 - (double)(histogram.bins - 1 - i) * 0.001953125);
            dequantized[i] = (double)i / (double)(histogram.bins - 1);
        }
        HashMap<IntPoint, double[]> mappings = new HashMap<IntPoint, double[]>();
        for (IntPoint corner : blocks.secondary.blocks) {
            double[] mapping = new double[histogram.bins];
            mappings.put(corner, mapping);
            if (!blockMask.get(corner, false) && !blockMask.get(corner.x - 1, corner.y, false) && !blockMask.get(corner.x, corner.y - 1, false) && !blockMask.get(corner.x - 1, corner.y - 1, false)) continue;
            double step = 2.0 / (double)histogram.sum(corner);
            double top = -1.0;
            for (int i = 0; i < histogram.bins; ++i) {
                double band = (double)histogram.get(corner, i) * step;
                double equalized = top + dequantized[i] * band;
                top += band;
                if (equalized < limitedMin[i]) {
                    equalized = limitedMin[i];
                }
                if (equalized > limitedMax[i]) {
                    equalized = limitedMax[i];
                }
                mapping[i] = equalized;
            }
        }
        DoubleMatrix result = new DoubleMatrix(blocks.pixels);
        for (IntPoint block : blocks.primary.blocks) {
            IntRect area = blocks.primary.block(block);
            if (blockMask.get(block)) {
                double[] topleft = (double[])mappings.get(block);
                double[] topright = (double[])mappings.get(new IntPoint(block.x + 1, block.y));
                double[] bottomleft = (double[])mappings.get(new IntPoint(block.x, block.y + 1));
                double[] bottomright = (double[])mappings.get(new IntPoint(block.x + 1, block.y + 1));
                for (int y = area.top(); y < area.bottom(); ++y) {
                    for (int x = area.left(); x < area.right(); ++x) {
                        int depth = histogram.constrain((int)(image.get(x, y) * (double)histogram.bins));
                        double rx = ((double)(x - area.x) + 0.5) / (double)area.width;
                        double ry = ((double)(y - area.y) + 0.5) / (double)area.height;
                        result.set(x, y, Doubles.interpolate(bottomleft[depth], bottomright[depth], topleft[depth], topright[depth], rx, ry));
                    }
                }
                continue;
            }
            for (int y = area.top(); y < area.bottom(); ++y) {
                for (int x = area.left(); x < area.right(); ++x) {
                    result.set(x, y, -1.0);
                }
            }
        }
        FingerprintTransparency.current().log("equalized-image", result);
        return result;
    }

    private static DoubleMatrix orientationMap(DoubleMatrix image, BooleanMatrix mask, BlockMap blocks) {
        DoublePointMatrix accumulated = FeatureExtractor.pixelwiseOrientation(image, mask, blocks);
        DoublePointMatrix byBlock = FeatureExtractor.blockOrientations(accumulated, blocks, mask);
        DoublePointMatrix smooth = FeatureExtractor.smoothOrientation(byBlock, mask);
        return FeatureExtractor.orientationAngles(smooth, mask);
    }

    private static ConsideredOrientation[][] planOrientations() {
        OrientationRandom random = new OrientationRandom();
        ConsideredOrientation[][] splits = new ConsideredOrientation[50][];
        for (int i = 0; i < 50; ++i) {
            splits[i] = new ConsideredOrientation[20];
            ConsideredOrientation[] orientations = splits[i];
            for (int j = 0; j < 20; ++j) {
                ConsideredOrientation sample = orientations[j] = new ConsideredOrientation();
                do {
                    double angle = random.next() * Math.PI;
                    double distance = Doubles.interpolateExponential(2.0, 6.0, random.next());
                    sample.offset = DoubleAngle.toVector(angle).multiply(distance).round();
                } while (sample.offset.equals(IntPoint.ZERO) || sample.offset.y < 0 || Arrays.stream(orientations).limit(j).anyMatch(o -> o.offset.equals(sample.offset)));
                sample.orientation = DoubleAngle.toVector(DoubleAngle.add(DoubleAngle.toOrientation(DoubleAngle.atan(sample.offset.toPoint())), Math.PI));
            }
        }
        return splits;
    }

    private static DoublePointMatrix pixelwiseOrientation(DoubleMatrix input, BooleanMatrix mask, BlockMap blocks) {
        ConsideredOrientation[][] neighbors = FeatureExtractor.planOrientations();
        DoublePointMatrix orientation = new DoublePointMatrix(input.size());
        for (int blockY = 0; blockY < blocks.primary.blocks.y; ++blockY) {
            IntRange maskRange = FeatureExtractor.maskRange(mask, blockY);
            if (maskRange.length() <= 0) continue;
            IntRange validXRange = new IntRange(blocks.primary.block(maskRange.start, blockY).left(), blocks.primary.block(maskRange.end - 1, blockY).right());
            for (int y = blocks.primary.block(0, blockY).top(); y < blocks.primary.block(0, blockY).bottom(); ++y) {
                for (ConsideredOrientation neighbor : neighbors[y % neighbors.length]) {
                    int radius = Math.max(Math.abs(neighbor.offset.x), Math.abs(neighbor.offset.y));
                    if (y - radius < 0 || y + radius >= input.height) continue;
                    IntRange xRange = new IntRange(Math.max(radius, validXRange.start), Math.min(input.width - radius, validXRange.end));
                    for (int x = xRange.start; x < xRange.end; ++x) {
                        double after;
                        double before = input.get(x - neighbor.offset.x, y - neighbor.offset.y);
                        double at = input.get(x, y);
                        double strength = at - Math.max(before, after = input.get(x + neighbor.offset.x, y + neighbor.offset.y));
                        if (!(strength > 0.0)) continue;
                        orientation.add(x, y, neighbor.orientation.multiply(strength));
                    }
                }
            }
        }
        FingerprintTransparency.current().log("pixelwise-orientation", orientation);
        return orientation;
    }

    private static IntRange maskRange(BooleanMatrix mask, int y) {
        int first = -1;
        int last = -1;
        for (int x = 0; x < mask.width; ++x) {
            if (!mask.get(x, y)) continue;
            last = x;
            if (first >= 0) continue;
            first = x;
        }
        if (first >= 0) {
            return new IntRange(first, last + 1);
        }
        return IntRange.ZERO;
    }

    private static DoublePointMatrix blockOrientations(DoublePointMatrix orientation, BlockMap blocks, BooleanMatrix mask) {
        DoublePointMatrix sums = new DoublePointMatrix(blocks.primary.blocks);
        for (IntPoint block : blocks.primary.blocks) {
            if (!mask.get(block)) continue;
            IntRect area = blocks.primary.block(block);
            for (int y = area.top(); y < area.bottom(); ++y) {
                for (int x = area.left(); x < area.right(); ++x) {
                    sums.add(block, orientation.get(x, y));
                }
            }
        }
        FingerprintTransparency.current().log("block-orientation", sums);
        return sums;
    }

    private static DoublePointMatrix smoothOrientation(DoublePointMatrix orientation, BooleanMatrix mask) {
        IntPoint size = mask.size();
        DoublePointMatrix smoothed = new DoublePointMatrix(size);
        for (IntPoint block : size) {
            if (!mask.get(block)) continue;
            IntRect neighbors = IntRect.around(block, 1).intersect(new IntRect(size));
            for (int ny = neighbors.top(); ny < neighbors.bottom(); ++ny) {
                for (int nx = neighbors.left(); nx < neighbors.right(); ++nx) {
                    if (!mask.get(nx, ny)) continue;
                    smoothed.add(block, orientation.get(nx, ny));
                }
            }
        }
        FingerprintTransparency.current().log("smoothed-orientation", smoothed);
        return smoothed;
    }

    private static DoubleMatrix orientationAngles(DoublePointMatrix vectors, BooleanMatrix mask) {
        IntPoint size = mask.size();
        DoubleMatrix angles = new DoubleMatrix(size);
        for (IntPoint block : size) {
            if (!mask.get(block)) continue;
            angles.set(block, DoubleAngle.atan(vectors.get(block)));
        }
        return angles;
    }

    private static IntPoint[][] orientedLines(int resolution, int radius, double step) {
        IntPoint[][] result = new IntPoint[resolution][];
        for (int orientationIndex = 0; orientationIndex < resolution; ++orientationIndex) {
            ArrayList<IntPoint> line = new ArrayList<IntPoint>();
            line.add(IntPoint.ZERO);
            DoublePoint direction = DoubleAngle.toVector(DoubleAngle.fromOrientation(DoubleAngle.bucketCenter(orientationIndex, resolution)));
            for (double r = (double)radius; r >= 0.5; r /= step) {
                IntPoint sample = direction.multiply(r).round();
                if (line.contains(sample)) continue;
                line.add(sample);
                line.add(sample.negate());
            }
            result[orientationIndex] = line.toArray(new IntPoint[line.size()]);
        }
        return result;
    }

    private static DoubleMatrix smoothRidges(DoubleMatrix input, DoubleMatrix orientation, BooleanMatrix mask, BlockMap blocks, double angle, IntPoint[][] lines) {
        DoubleMatrix output = new DoubleMatrix(input.size());
        for (IntPoint block : blocks.primary.blocks) {
            IntPoint[] line;
            if (!mask.get(block)) continue;
            for (IntPoint linePoint : line = lines[DoubleAngle.quantize(DoubleAngle.add(orientation.get(block), angle), lines.length)]) {
                IntRect target = blocks.primary.block(block);
                IntRect source = target.move(linePoint).intersect(new IntRect(blocks.pixels));
                target = source.move(linePoint.negate());
                for (int y = target.top(); y < target.bottom(); ++y) {
                    for (int x = target.left(); x < target.right(); ++x) {
                        output.add(x, y, input.get(x + linePoint.x, y + linePoint.y));
                    }
                }
            }
            IntRect blockArea = blocks.primary.block(block);
            for (int y = blockArea.top(); y < blockArea.bottom(); ++y) {
                for (int x = blockArea.left(); x < blockArea.right(); ++x) {
                    output.multiply(x, y, 1.0 / (double)line.length);
                }
            }
        }
        return output;
    }

    private static BooleanMatrix binarize(DoubleMatrix input, DoubleMatrix baseline, BooleanMatrix mask, BlockMap blocks) {
        IntPoint size = input.size();
        BooleanMatrix binarized = new BooleanMatrix(size);
        for (IntPoint block : blocks.primary.blocks) {
            if (!mask.get(block)) continue;
            IntRect rect = blocks.primary.block(block);
            for (int y = rect.top(); y < rect.bottom(); ++y) {
                for (int x = rect.left(); x < rect.right(); ++x) {
                    if (!(input.get(x, y) - baseline.get(x, y) > 0.0)) continue;
                    binarized.set(x, y, true);
                }
            }
        }
        FingerprintTransparency.current().log("binarized-image", binarized);
        return binarized;
    }

    private static void cleanupBinarized(BooleanMatrix binary, BooleanMatrix mask) {
        IntPoint size = binary.size();
        BooleanMatrix inverted = new BooleanMatrix(binary);
        inverted.invert();
        BooleanMatrix islands = FeatureExtractor.vote(inverted, mask, 2, 0.61, 17);
        BooleanMatrix holes = FeatureExtractor.vote(binary, mask, 2, 0.61, 17);
        for (int y = 0; y < size.y; ++y) {
            for (int x = 0; x < size.x; ++x) {
                binary.set(x, y, binary.get(x, y) && !islands.get(x, y) || holes.get(x, y));
            }
        }
        FeatureExtractor.removeCrosses(binary);
        FingerprintTransparency.current().log("filtered-binary-image", binary);
    }

    private static void removeCrosses(BooleanMatrix input) {
        IntPoint size = input.size();
        boolean any = true;
        while (any) {
            any = false;
            for (int y = 0; y < size.y - 1; ++y) {
                for (int x = 0; x < size.x - 1; ++x) {
                    if ((!input.get(x, y) || !input.get(x + 1, y + 1) || input.get(x, y + 1) || input.get(x + 1, y)) && (!input.get(x, y + 1) || !input.get(x + 1, y) || input.get(x, y) || input.get(x + 1, y + 1))) continue;
                    input.set(x, y, false);
                    input.set(x, y + 1, false);
                    input.set(x + 1, y, false);
                    input.set(x + 1, y + 1, false);
                    any = true;
                }
            }
        }
    }

    private static BooleanMatrix fillBlocks(BooleanMatrix mask, BlockMap blocks) {
        BooleanMatrix pixelized = new BooleanMatrix(blocks.pixels);
        for (IntPoint block : blocks.primary.blocks) {
            if (!mask.get(block)) continue;
            for (IntPoint pixel : blocks.primary.block(block)) {
                pixelized.set(pixel, true);
            }
        }
        return pixelized;
    }

    private static BooleanMatrix invert(BooleanMatrix binary, BooleanMatrix mask) {
        IntPoint size = binary.size();
        BooleanMatrix inverted = new BooleanMatrix(size);
        for (int y = 0; y < size.y; ++y) {
            for (int x = 0; x < size.x; ++x) {
                inverted.set(x, y, !binary.get(x, y) && mask.get(x, y));
            }
        }
        return inverted;
    }

    private static BooleanMatrix innerMask(BooleanMatrix outer) {
        IntPoint size = outer.size();
        BooleanMatrix inner = new BooleanMatrix(size);
        for (int y = 1; y < size.y - 1; ++y) {
            for (int x = 1; x < size.x - 1; ++x) {
                inner.set(x, y, outer.get(x, y));
            }
        }
        inner = FeatureExtractor.shrinkMask(inner, 1);
        int total = 1;
        int step = 1;
        while (total + step <= 14) {
            inner = FeatureExtractor.shrinkMask(inner, step);
            total += step;
            step *= 2;
        }
        if (total < 14) {
            inner = FeatureExtractor.shrinkMask(inner, 14 - total);
        }
        FingerprintTransparency.current().log("inner-mask", inner);
        return inner;
    }

    private static BooleanMatrix shrinkMask(BooleanMatrix mask, int amount) {
        IntPoint size = mask.size();
        BooleanMatrix shrunk = new BooleanMatrix(size);
        for (int y = amount; y < size.y - amount; ++y) {
            for (int x = amount; x < size.x - amount; ++x) {
                shrunk.set(x, y, mask.get(x, y - amount) && mask.get(x, y + amount) && mask.get(x - amount, y) && mask.get(x + amount, y));
            }
        }
        return shrunk;
    }

    private static void collectMinutiae(List<MutableMinutia> minutiae, Skeleton skeleton, MinutiaType type) {
        for (SkeletonMinutia sminutia : skeleton.minutiae) {
            if (sminutia.ridges.size() != 1) continue;
            minutiae.add(new MutableMinutia(sminutia.position, sminutia.ridges.get(0).direction(), type));
        }
    }

    private static void maskMinutiae(List<MutableMinutia> minutiae, BooleanMatrix mask) {
        minutiae.removeIf(minutia -> {
            IntPoint arrow = DoubleAngle.toVector(minutia.direction).multiply(-10.06).round();
            return !mask.get(minutia.position.plus(arrow), false);
        });
    }

    private static void removeMinutiaClouds(List<MutableMinutia> minutiae) {
        int radiusSq = Integers.sq(20);
        minutiae.removeAll(minutiae.stream().filter(minutia -> 4L < minutiae.stream().filter(neighbor -> neighbor.position.minus(minutia.position).lengthSq() <= radiusSq).count() - 1L).collect(Collectors.toList()));
    }

    private static List<MutableMinutia> limitTemplateSize(List<MutableMinutia> minutiae) {
        if (minutiae.size() <= 100) {
            return minutiae;
        }
        return minutiae.stream().sorted(Comparator.comparingInt(minutia -> minutiae.stream().mapToInt(neighbor -> minutia.position.minus(neighbor.position).lengthSq()).sorted().skip(5L).findFirst().orElse(Integer.MAX_VALUE)).reversed()).limit(100L).collect(Collectors.toList());
    }

    private static class OrientationRandom {
        static final int PRIME = 0x60000005;
        static final int BITS = 30;
        static final int MASK = 0x3FFFFFFF;
        static final double SCALING = 9.313225746154785E-10;
        long state = 536871037L;

        private OrientationRandom() {
        }

        double next() {
            this.state *= 0x60000005L;
            return ((double)(this.state & 0x3FFFFFFFL) + 0.5) * 9.313225746154785E-10;
        }
    }

    private static class ConsideredOrientation {
        IntPoint offset;
        DoublePoint orientation;

        private ConsideredOrientation() {
        }
    }
}

