/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleMatrix;
import com.machinezoo.sourceafis.ImageDecoder;
import com.machinezoo.sourceafis.PlatformCheck;
import java.util.Objects;

public class FingerprintImage {
    double dpi = 500.0;
    DoubleMatrix matrix;

    public FingerprintImage dpi(double dpi) {
        if (dpi < 20.0 || dpi > 20000.0) {
            throw new IllegalArgumentException();
        }
        this.dpi = dpi;
        return this;
    }

    public FingerprintImage decode(byte[] image) {
        Objects.requireNonNull(image);
        ImageDecoder.DecodedImage decoded = ImageDecoder.decodeAny(image);
        this.matrix = new DoubleMatrix(decoded.width, decoded.height);
        for (int y = 0; y < decoded.height; ++y) {
            for (int x = 0; x < decoded.width; ++x) {
                int pixel = decoded.pixels[y * decoded.width + x];
                int color = (pixel & 0xFF) + (pixel >> 8 & 0xFF) + (pixel >> 16 & 0xFF);
                this.matrix.set(x, y, 1.0 - (double)color * 0.00130718954248366);
            }
        }
        return this;
    }

    public FingerprintImage grayscale(int width, int height, byte[] pixels) {
        Objects.requireNonNull(pixels);
        if (width <= 0 || height <= 0 || pixels.length != width * height) {
            throw new IndexOutOfBoundsException();
        }
        this.matrix = new DoubleMatrix(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.matrix.set(x, y, 1.0 - (double)Byte.toUnsignedInt(pixels[y * width + x]) / 255.0);
            }
        }
        return this;
    }

    static {
        PlatformCheck.run();
    }
}

