/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.CircularList;
import com.machinezoo.sourceafis.FingerprintCompatibility;
import com.machinezoo.sourceafis.IndexedEdge;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.MinutiaPair;
import com.machinezoo.sourceafis.PlatformCheck;
import com.machinezoo.sourceafis.Score;
import com.machinezoo.sourceafis.Skeleton;
import com.machinezoo.sourceafis.SkeletonMinutia;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class FingerprintTransparency
implements AutoCloseable {
    private static final ThreadLocal<FingerprintTransparency> current;
    private FingerprintTransparency outer = current.get();
    private boolean closed;
    private static final FingerprintTransparency NOOP;
    private static final ObjectMapper mapper;
    private volatile boolean versionOffered;
    private volatile boolean matcherOffered;
    private volatile boolean acceptsRootPairs;
    private volatile boolean acceptsPairing;
    private volatile boolean acceptsScore;
    private volatile boolean acceptsBestMatch;

    protected FingerprintTransparency() {
        current.set(this);
    }

    public boolean accepts(String key) {
        return true;
    }

    private static String suffix(String mime) {
        switch (mime) {
            case "application/cbor": {
                return ".cbor";
            }
            case "text/plain": {
                return ".txt";
            }
            case "application/json": {
                return ".json";
            }
            case "application/xml": {
                return ".xml";
            }
            case "image/jpeg": {
                return ".jpeg";
            }
            case "image/png": {
                return ".png";
            }
            case "image/bmp": {
                return ".bmp";
            }
            case "image/tiff": {
                return ".tiff";
            }
            case "image/jp2": {
                return ".jp2";
            }
            case "image/x-wsq": {
                return ".wsq";
            }
        }
        return ".dat";
    }

    public void take(String key, String mime, byte[] data) {
        HashMap<String, Supplier<byte[]>> map = new HashMap<String, Supplier<byte[]>>();
        map.put(FingerprintTransparency.suffix(mime), () -> data);
        this.capture(key, map);
    }

    @Deprecated
    protected void capture(String key, Map<String, Supplier<byte[]>> data) {
        HashMap<String, Supplier<ByteBuffer>> translated = new HashMap<String, Supplier<ByteBuffer>>();
        for (Map.Entry<String, Supplier<byte[]>> entry : data.entrySet()) {
            translated.put(entry.getKey(), () -> ByteBuffer.wrap((byte[])((Supplier)entry.getValue()).get()));
        }
        this.log(key, translated);
    }

    @Deprecated
    protected void log(String key, Map<String, Supplier<ByteBuffer>> data) {
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            current.set(this.outer);
            this.outer = null;
        }
    }

    public static FingerprintTransparency zip(OutputStream stream) {
        return new TransparencyZip(stream);
    }

    static FingerprintTransparency current() {
        return Optional.ofNullable(current.get()).orElse(NOOP);
    }

    private byte[] cbor(Object data) {
        return (byte[])Exceptions.wrap(IllegalArgumentException::new).get(() -> mapper.writeValueAsBytes(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logVersion() {
        if (!this.versionOffered) {
            boolean offer = false;
            FingerprintTransparency fingerprintTransparency = this;
            synchronized (fingerprintTransparency) {
                if (!this.versionOffered) {
                    this.versionOffered = true;
                    offer = true;
                }
            }
            if (offer && this.accepts("version")) {
                this.take("version", "text/plain", FingerprintCompatibility.version().getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private void log(String key, String mime, Supplier<byte[]> supplier) {
        this.logVersion();
        if (this.accepts(key)) {
            this.take(key, mime, supplier.get());
        }
    }

    void log(String key, Supplier<?> supplier) {
        this.log(key, "application/cbor", () -> this.cbor(supplier.get()));
    }

    void log(String key, Object data) {
        this.log(key, "application/cbor", () -> this.cbor(data));
    }

    void logSkeleton(String keyword, Skeleton skeleton) {
        this.log(skeleton.type.prefix + keyword, () -> new CborSkeleton(skeleton));
    }

    void logEdgeHash(Int2ObjectMap<List<IndexedEdge>> hash) {
        this.log("edge-hash", () -> Arrays.stream(hash.keySet().toIntArray()).sorted().mapToObj(key -> {
            CborHashEntry entry = new CborHashEntry();
            entry.key = key;
            entry.edges = (List)hash.get(key);
            return entry;
        }).collect(Collectors.toList()));
    }

    private void offerMatcher() {
        if (!this.matcherOffered) {
            this.acceptsRootPairs = this.accepts("root-pairs");
            this.acceptsPairing = this.accepts("pairing");
            this.acceptsScore = this.accepts("score");
            this.acceptsBestMatch = this.accepts("best-match");
            this.matcherOffered = true;
        }
    }

    void logRootPairs(int count, MinutiaPair[] roots) {
        this.offerMatcher();
        if (this.acceptsRootPairs) {
            this.log("roots", () -> CborPair.roots(count, roots));
        }
    }

    boolean acceptsPairing() {
        this.offerMatcher();
        return this.acceptsPairing;
    }

    void logPairing(int count, MinutiaPair[] pairs, List<MinutiaPair> support) {
        this.offerMatcher();
        if (this.acceptsPairing) {
            this.log("pairing", new CborPairing(count, pairs, support));
        }
    }

    void logScore(Score score) {
        this.offerMatcher();
        if (this.acceptsScore) {
            this.log("score", score);
        }
    }

    void logBestMatch(int nth) {
        this.offerMatcher();
        if (this.acceptsBestMatch) {
            this.take("best-match", "text/plain", Integer.toString(nth).getBytes(StandardCharsets.UTF_8));
        }
    }

    static {
        PlatformCheck.run();
        current = new ThreadLocal();
        NOOP = new NoFingerprintTransparency();
        NOOP.close();
        mapper = new ObjectMapper((JsonFactory)new CBORFactory()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    private static class CborPairing {
        CborPair root;
        List<CborEdge> tree;
        List<CborEdge> support;

        CborPairing(int count, MinutiaPair[] pairs, List<MinutiaPair> support) {
            this.root = new CborPair(pairs[0].probe, pairs[0].candidate);
            this.tree = Arrays.stream(pairs).limit(count).skip(1L).map(CborEdge::new).collect(Collectors.toList());
            this.support = support.stream().map(CborEdge::new).collect(Collectors.toList());
        }
    }

    private static class CborEdge {
        int probeFrom;
        int probeTo;
        int candidateFrom;
        int candidateTo;

        CborEdge(MinutiaPair pair) {
            this.probeFrom = pair.probeRef;
            this.probeTo = pair.probe;
            this.candidateFrom = pair.candidateRef;
            this.candidateTo = pair.candidate;
        }
    }

    private static class CborPair {
        int probe;
        int candidate;

        CborPair(int probe, int candidate) {
            this.probe = probe;
            this.candidate = candidate;
        }

        static List<CborPair> roots(int count, MinutiaPair[] roots) {
            return Arrays.stream(roots).limit(count).map(p -> new CborPair(p.probe, p.candidate)).collect(Collectors.toList());
        }
    }

    private static class CborHashEntry {
        int key;
        List<IndexedEdge> edges;

        private CborHashEntry() {
        }
    }

    private static class CborSkeleton {
        int width;
        int height;
        List<IntPoint> minutiae;
        List<CborSkeletonRidge> ridges;

        CborSkeleton(Skeleton skeleton) {
            this.width = skeleton.size.x;
            this.height = skeleton.size.y;
            HashMap<SkeletonMinutia, Integer> offsets = new HashMap<SkeletonMinutia, Integer>();
            for (int i = 0; i < skeleton.minutiae.size(); ++i) {
                offsets.put(skeleton.minutiae.get(i), i);
            }
            this.minutiae = skeleton.minutiae.stream().map(m -> m.position).collect(Collectors.toList());
            this.ridges = skeleton.minutiae.stream().flatMap(m -> m.ridges.stream().filter(r -> r.points instanceof CircularList).map(r -> {
                CborSkeletonRidge jr = new CborSkeletonRidge();
                jr.start = (Integer)offsets.get(r.start());
                jr.end = (Integer)offsets.get(r.end());
                jr.points = r.points;
                return jr;
            })).collect(Collectors.toList());
        }
    }

    private static class CborSkeletonRidge {
        int start;
        int end;
        List<IntPoint> points;

        private CborSkeletonRidge() {
        }
    }

    private static class NoFingerprintTransparency
    extends FingerprintTransparency {
        private NoFingerprintTransparency() {
        }

        @Override
        public boolean accepts(String key) {
            return false;
        }
    }

    private static class TransparencyZip
    extends FingerprintTransparency {
        private final ZipOutputStream zip;
        private int offset;

        TransparencyZip(OutputStream stream) {
            this.zip = new ZipOutputStream(stream);
        }

        @Override
        public synchronized void take(String key, String mime, byte[] data) {
            ++this.offset;
            Exceptions.wrap().run(() -> {
                this.zip.putNextEntry(new ZipEntry(String.format("%03d", this.offset) + "-" + key + FingerprintTransparency.suffix(mime)));
                this.zip.write(data);
                this.zip.closeEntry();
            });
        }

        @Override
        public void close() {
            super.close();
            Exceptions.wrap().run(this.zip::close);
        }
    }
}

