/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.PlatformCheck;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.sanselan.Sanselan;
import org.jnbis.api.Jnbis;
import org.jnbis.api.model.Bitmap;

abstract class ImageDecoder {
    private static final List<ImageDecoder> all = Arrays.asList(new ImageIODecoder(), new SanselanDecoder(), new WsqDecoder(), new AndroidDecoder());

    ImageDecoder() {
    }

    abstract boolean available();

    abstract String name();

    abstract DecodedImage decode(byte[] var1);

    static DecodedImage decodeAny(byte[] image) {
        HashMap<ImageDecoder, Throwable> exceptions = new HashMap<ImageDecoder, Throwable>();
        for (ImageDecoder decoder : all) {
            try {
                if (!decoder.available()) {
                    throw new UnsupportedOperationException("Image decoder is not available.");
                }
                return decoder.decode(image);
            }
            catch (Throwable ex) {
                exceptions.put(decoder, ex);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported image format [%s].", all.stream().map(d -> String.format("%s = '%s'", d.name(), ImageDecoder.formatError((Throwable)exceptions.get(d)))).collect(Collectors.joining(", "))));
    }

    private static String formatError(Throwable exception) {
        ArrayList<Throwable> ancestors = new ArrayList<Throwable>();
        for (Throwable ancestor = exception; ancestor != null; ancestor = ancestor.getCause()) {
            ancestors.add(ancestor);
        }
        return ancestors.stream().map(ex -> ex.toString()).collect(Collectors.joining(" -> "));
    }

    private static class AndroidDecoder
    extends ImageDecoder {
        private AndroidDecoder() {
        }

        @Override
        boolean available() {
            return PlatformCheck.hasClass("android.graphics.BitmapFactory");
        }

        @Override
        String name() {
            return "Android";
        }

        @Override
        DecodedImage decode(byte[] image) {
            AndroidBitmap bitmap = AndroidBitmapFactory.decodeByteArray(image, 0, image.length);
            if (bitmap.instance == null) {
                throw new IllegalArgumentException("Unsupported image format.");
            }
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            return new DecodedImage(width, height, pixels);
        }

        static class AndroidBitmap {
            static Class<?> clazz = (Class)Exceptions.sneak().get(() -> Class.forName("android.graphics.Bitmap"));
            static Method getWidth = (Method)Exceptions.sneak().get(() -> clazz.getMethod("getWidth", new Class[0]));
            static Method getHeight = (Method)Exceptions.sneak().get(() -> clazz.getMethod("getHeight", new Class[0]));
            static Method getPixels = (Method)Exceptions.sneak().get(() -> clazz.getMethod("getPixels", int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE));
            final Object instance;

            AndroidBitmap(Object instance) {
                this.instance = instance;
            }

            int getWidth() {
                return Exceptions.sneak().getAsInt(() -> (Integer)getWidth.invoke(this.instance, new Object[0]));
            }

            int getHeight() {
                return Exceptions.sneak().getAsInt(() -> (Integer)getHeight.invoke(this.instance, new Object[0]));
            }

            void getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
                Exceptions.sneak().run(() -> getPixels.invoke(this.instance, pixels, offset, stride, x, y, width, height));
            }
        }

        static class AndroidBitmapFactory {
            static Class<?> clazz = (Class)Exceptions.sneak().get(() -> Class.forName("android.graphics.BitmapFactory"));
            static Method decodeByteArray = (Method)Exceptions.sneak().get(() -> clazz.getMethod("decodeByteArray", byte[].class, Integer.TYPE, Integer.TYPE));

            AndroidBitmapFactory() {
            }

            static AndroidBitmap decodeByteArray(byte[] data, int offset, int length) {
                return new AndroidBitmap(Exceptions.sneak().get(() -> decodeByteArray.invoke(null, data, offset, length)));
            }
        }
    }

    private static class WsqDecoder
    extends ImageDecoder {
        private WsqDecoder() {
        }

        @Override
        boolean available() {
            return true;
        }

        @Override
        String name() {
            return "WSQ";
        }

        @Override
        DecodedImage decode(byte[] image) {
            if (image.length < 2 || image[0] != -1 || image[1] != -96) {
                throw new IllegalArgumentException("This is not a WSQ image.");
            }
            return (DecodedImage)Exceptions.sneak().get(() -> {
                Bitmap bitmap = Jnbis.wsq().decode(image).asBitmap();
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                byte[] buffer = bitmap.getPixels();
                int[] pixels = new int[width * height];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int gray = buffer[y * width + x] & 0xFF;
                        pixels[y * width + x] = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    }
                }
                return new DecodedImage(width, height, pixels);
            });
        }
    }

    private static class SanselanDecoder
    extends ImageDecoder {
        private SanselanDecoder() {
        }

        @Override
        boolean available() {
            return PlatformCheck.hasClass("java.awt.image.BufferedImage");
        }

        @Override
        String name() {
            return "Sanselan";
        }

        @Override
        DecodedImage decode(byte[] image) {
            return (DecodedImage)Exceptions.sneak().get(() -> {
                BufferedImage buffered = Sanselan.getBufferedImage((InputStream)new ByteArrayInputStream(image));
                int width = buffered.getWidth();
                int height = buffered.getHeight();
                int[] pixels = new int[width * height];
                buffered.getRGB(0, 0, width, height, pixels, 0, width);
                return new DecodedImage(width, height, pixels);
            });
        }
    }

    private static class ImageIODecoder
    extends ImageDecoder {
        private ImageIODecoder() {
        }

        @Override
        boolean available() {
            return PlatformCheck.hasClass("javax.imageio.ImageIO");
        }

        @Override
        String name() {
            return "ImageIO";
        }

        @Override
        DecodedImage decode(byte[] image) {
            return (DecodedImage)Exceptions.sneak().get(() -> {
                BufferedImage buffered = ImageIO.read(new ByteArrayInputStream(image));
                if (buffered == null) {
                    throw new IllegalArgumentException("Unsupported image format.");
                }
                int width = buffered.getWidth();
                int height = buffered.getHeight();
                int[] pixels = new int[width * height];
                buffered.getRGB(0, 0, width, height, pixels, 0, width);
                return new DecodedImage(width, height, pixels);
            });
        }
    }

    static class DecodedImage {
        int width;
        int height;
        int[] pixels;

        DecodedImage(int width, int height, int[] pixels) {
            this.width = width;
            this.height = height;
            this.pixels = pixels;
        }
    }
}

