/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ImmutableMinutia;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.MutableTemplate;
import com.machinezoo.sourceafis.NeighborEdge;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;

class ImmutableTemplate {
    static final ImmutableTemplate EMPTY = new ImmutableTemplate();
    final IntPoint size;
    final ImmutableMinutia[] minutiae;
    final NeighborEdge[][] edges;
    private static final int PRIME = 0x60000005;

    private ImmutableTemplate() {
        this.size = new IntPoint(1, 1);
        this.minutiae = new ImmutableMinutia[0];
        this.edges = new NeighborEdge[0][];
    }

    ImmutableTemplate(MutableTemplate mutable) {
        this.size = mutable.size;
        this.minutiae = (ImmutableMinutia[])mutable.minutiae.stream().map(ImmutableMinutia::new).sorted(Comparator.comparingInt(m -> (m.position.x * 0x60000005 + m.position.y) * 0x60000005).thenComparing(m -> m.position.x).thenComparing(m -> m.position.y).thenComparing(m -> m.direction).thenComparing(m -> m.type)).toArray(ImmutableMinutia[]::new);
        FingerprintTransparency.current().log("shuffled-minutiae", this::mutable);
        this.edges = NeighborEdge.buildTable(this.minutiae);
    }

    MutableTemplate mutable() {
        MutableTemplate mutable = new MutableTemplate();
        mutable.size = this.size;
        mutable.minutiae = Arrays.stream(this.minutiae).map(ImmutableMinutia::mutable).collect(Collectors.toList());
        return mutable;
    }
}

