/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.EdgeShape;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ImmutableMinutia;
import com.machinezoo.sourceafis.IntPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

class NeighborEdge
extends EdgeShape {
    final int neighbor;

    NeighborEdge(ImmutableMinutia[] minutiae, int reference, int neighbor) {
        super(minutiae[reference], minutiae[neighbor]);
        this.neighbor = neighbor;
    }

    static NeighborEdge[][] buildTable(ImmutableMinutia[] minutiae) {
        NeighborEdge[][] edges = new NeighborEdge[minutiae.length][];
        ArrayList<NeighborEdge> star = new ArrayList<NeighborEdge>();
        int[] allSqDistances = new int[minutiae.length];
        for (int reference = 0; reference < edges.length; ++reference) {
            int neighbor;
            IntPoint referencePosition = minutiae[reference].position;
            int maxSqDistance = Integer.MAX_VALUE;
            if (minutiae.length - 1 > 9) {
                for (neighbor = 0; neighbor < minutiae.length; ++neighbor) {
                    allSqDistances[neighbor] = referencePosition.minus(minutiae[neighbor].position).lengthSq();
                }
                Arrays.sort(allSqDistances);
                maxSqDistance = allSqDistances[9];
            }
            for (neighbor = 0; neighbor < minutiae.length; ++neighbor) {
                if (neighbor == reference || referencePosition.minus(minutiae[neighbor].position).lengthSq() > maxSqDistance) continue;
                star.add(new NeighborEdge(minutiae, reference, neighbor));
            }
            star.sort(Comparator.comparingInt(e -> e.length).thenComparingInt(e -> e.neighbor));
            while (star.size() > 9) {
                star.remove(star.size() - 1);
            }
            edges[reference] = star.toArray(new NeighborEdge[star.size()]);
            star.clear();
        }
        FingerprintTransparency.current().log("edge-table", edges);
        return edges;
    }
}

