/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.EdgeShape;
import com.machinezoo.sourceafis.MatcherThread;
import com.machinezoo.sourceafis.MinutiaPair;
import com.machinezoo.sourceafis.Parameters;

class Score {
    int minutiaCount;
    double minutiaScore;
    double minutiaFractionInProbe;
    double minutiaFractionInCandidate;
    double minutiaFraction;
    double minutiaFractionScore;
    int supportingEdgeSum;
    int edgeCount;
    double edgeScore;
    int supportedMinutiaCount;
    double supportedMinutiaScore;
    int minutiaTypeHits;
    double minutiaTypeScore;
    int distanceErrorSum;
    int distanceAccuracySum;
    double distanceAccuracyScore;
    double angleErrorSum;
    double angleAccuracySum;
    double angleAccuracyScore;
    double totalScore;
    double shapedScore;

    Score() {
    }

    void compute(MatcherThread thread) {
        this.minutiaCount = thread.count;
        this.minutiaScore = 0.032 * (double)this.minutiaCount;
        this.minutiaFractionInProbe = (double)thread.count / (double)thread.probe.minutiae.length;
        this.minutiaFractionInCandidate = (double)thread.count / (double)thread.candidate.minutiae.length;
        this.minutiaFraction = 0.5 * (this.minutiaFractionInProbe + this.minutiaFractionInCandidate);
        this.minutiaFractionScore = 8.98 * this.minutiaFraction;
        this.supportingEdgeSum = 0;
        this.supportedMinutiaCount = 0;
        this.minutiaTypeHits = 0;
        for (int i = 0; i < thread.count; ++i) {
            MinutiaPair pair = thread.tree[i];
            this.supportingEdgeSum += pair.supportingEdges;
            if (pair.supportingEdges >= 1) {
                ++this.supportedMinutiaCount;
            }
            if (thread.probe.minutiae[pair.probe].type != thread.candidate.minutiae[pair.candidate].type) continue;
            ++this.minutiaTypeHits;
        }
        this.edgeCount = thread.count + this.supportingEdgeSum;
        this.edgeScore = 0.265 * (double)this.edgeCount;
        this.supportedMinutiaScore = 0.193 * (double)this.supportedMinutiaCount;
        this.minutiaTypeScore = 0.629 * (double)this.minutiaTypeHits;
        int innerDistanceRadius = (int)Math.round(8.969999999999999);
        double innerAngleRadius = 0.27 * Parameters.MAX_ANGLE_ERROR;
        this.distanceErrorSum = 0;
        this.angleErrorSum = 0.0;
        for (int i = 1; i < thread.count; ++i) {
            MinutiaPair pair = thread.tree[i];
            EdgeShape probeEdge = new EdgeShape(thread.probe.minutiae[pair.probeRef], thread.probe.minutiae[pair.probe]);
            EdgeShape candidateEdge = new EdgeShape(thread.candidate.minutiae[pair.candidateRef], thread.candidate.minutiae[pair.candidate]);
            this.distanceErrorSum += Math.max(innerDistanceRadius, Math.abs(probeEdge.length - candidateEdge.length));
            this.angleErrorSum += Math.max(innerAngleRadius, DoubleAngle.distance(probeEdge.referenceAngle, candidateEdge.referenceAngle));
            this.angleErrorSum += Math.max(innerAngleRadius, DoubleAngle.distance(probeEdge.neighborAngle, candidateEdge.neighborAngle));
        }
        this.distanceAccuracyScore = 0.0;
        this.angleAccuracyScore = 0.0;
        int distanceErrorPotential = 13 * Math.max(0, thread.count - 1);
        this.distanceAccuracySum = distanceErrorPotential - this.distanceErrorSum;
        this.distanceAccuracyScore = 9.9 * (distanceErrorPotential > 0 ? (double)this.distanceAccuracySum / (double)distanceErrorPotential : 0.0);
        double angleErrorPotential = Parameters.MAX_ANGLE_ERROR * (double)Math.max(0, thread.count - 1) * 2.0;
        this.angleAccuracySum = angleErrorPotential - this.angleErrorSum;
        this.angleAccuracyScore = 2.79 * (angleErrorPotential > 0.0 ? this.angleAccuracySum / angleErrorPotential : 0.0);
        this.totalScore = this.minutiaScore + this.minutiaFractionScore + this.supportedMinutiaScore + this.edgeScore + this.minutiaTypeScore + this.distanceAccuracyScore + this.angleAccuracyScore;
        this.shapedScore = Score.shape(this.totalScore);
    }

    private static double shape(double raw) {
        if (raw < 8.48) {
            return 0.0;
        }
        if (raw < 11.12) {
            return Score.interpolate(raw, 8.48, 11.12, 0.0, 3.0);
        }
        if (raw < 14.15) {
            return Score.interpolate(raw, 11.12, 14.15, 3.0, 7.0);
        }
        if (raw < 18.22) {
            return Score.interpolate(raw, 14.15, 18.22, 10.0, 10.0);
        }
        if (raw < 22.39) {
            return Score.interpolate(raw, 18.22, 22.39, 20.0, 10.0);
        }
        if (raw < 27.24) {
            return Score.interpolate(raw, 22.39, 27.24, 30.0, 10.0);
        }
        if (raw < 32.01) {
            return Score.interpolate(raw, 27.24, 32.01, 40.0, 10.0);
        }
        return (raw - 32.01) / 13.79 * 30.0 + 50.0;
    }

    private static double interpolate(double raw, double min, double max, double start, double length) {
        return (raw - min) / (max - min) * length + start;
    }
}

