/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.fingerprintio.TemplateFormat;
import com.machinezoo.fingerprintio.ansi378.Ansi378Fingerprint;
import com.machinezoo.fingerprintio.ansi378.Ansi378Minutia;
import com.machinezoo.fingerprintio.ansi378.Ansi378MinutiaType;
import com.machinezoo.fingerprintio.ansi378.Ansi378Template;
import com.machinezoo.fingerprintio.ansi378.Ansi378v2009Am1Fingerprint;
import com.machinezoo.fingerprintio.ansi378.Ansi378v2009Am1Template;
import com.machinezoo.fingerprintio.ansi378.Ansi378v2009Fingerprint;
import com.machinezoo.fingerprintio.ansi378.Ansi378v2009Minutia;
import com.machinezoo.fingerprintio.ansi378.Ansi378v2009MinutiaType;
import com.machinezoo.fingerprintio.ansi378.Ansi378v2009Template;
import com.machinezoo.fingerprintio.iso19794p2.Iso19794p2Fingerprint;
import com.machinezoo.fingerprintio.iso19794p2.Iso19794p2Minutia;
import com.machinezoo.fingerprintio.iso19794p2.Iso19794p2MinutiaType;
import com.machinezoo.fingerprintio.iso19794p2.Iso19794p2Template;
import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.MinutiaType;
import com.machinezoo.sourceafis.MutableMinutia;
import com.machinezoo.sourceafis.MutableTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

abstract class TemplateCodec {
    static final Map<TemplateFormat, TemplateCodec> ALL = new HashMap<TemplateFormat, TemplateCodec>();

    TemplateCodec() {
    }

    abstract byte[] encode(List<MutableTemplate> var1);

    abstract List<MutableTemplate> decode(byte[] var1, boolean var2);

    List<MutableTemplate> decode(byte[] serialized) {
        try {
            return this.decode(serialized, false);
        }
        catch (Throwable ex) {
            return this.decode(serialized, true);
        }
    }

    static {
        ALL.put(TemplateFormat.ANSI_378, new Ansi378Codec());
        ALL.put(TemplateFormat.ANSI_378_2009, new Ansi378v2009Codec());
        ALL.put(TemplateFormat.ANSI_378_2009_AM1, new Ansi378v2009Am1Codec());
        ALL.put(TemplateFormat.ISO_19794_2, new Iso19794p2Codec());
    }

    private static class Iso19794p2Codec
    extends TemplateCodec {
        private Iso19794p2Codec() {
        }

        @Override
        byte[] encode(List<MutableTemplate> templates) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<MutableTemplate> decode(byte[] serialized, boolean permissive) {
            Iso19794p2Template iotemplate = new Iso19794p2Template(serialized, permissive);
            Resolution resolution = new Resolution();
            resolution.dpiX = (double)iotemplate.resolutionX * 2.54;
            resolution.dpiY = (double)iotemplate.resolutionY * 2.54;
            return iotemplate.fingerprints.stream().map(fp -> Iso19794p2Codec.decode(fp, iotemplate, resolution)).collect(Collectors.toList());
        }

        static MutableTemplate decode(Iso19794p2Fingerprint iofingerprint, Iso19794p2Template iotemplate, Resolution resolution) {
            MutableTemplate template = new MutableTemplate();
            template.size = Iso19794p2Codec.decode(iotemplate.width, iotemplate.height, resolution);
            template.minutiae = iofingerprint.minutiae.stream().map(m -> Iso19794p2Codec.decode(m, resolution)).collect(Collectors.toList());
            return template;
        }

        static MutableMinutia decode(Iso19794p2Minutia iominutia, Resolution resolution) {
            MutableMinutia minutia = new MutableMinutia();
            minutia.position = Iso19794p2Codec.decode(iominutia.positionX, iominutia.positionY, resolution);
            minutia.direction = Iso19794p2Codec.decodeAngle(iominutia.angle);
            minutia.type = Iso19794p2Codec.decode(iominutia.type);
            return minutia;
        }

        static double decodeAngle(int ioangle) {
            return DoubleAngle.complementary((double)ioangle / 256.0 * (Math.PI * 2));
        }

        static MinutiaType decode(Iso19794p2MinutiaType iotype) {
            switch (iotype) {
                case ENDING: {
                    return MinutiaType.ENDING;
                }
                case BIFURCATION: {
                    return MinutiaType.BIFURCATION;
                }
            }
            return MinutiaType.ENDING;
        }

        static IntPoint decode(int x, int y, Resolution resolution) {
            return new IntPoint(Iso19794p2Codec.decode(x, resolution.dpiX), Iso19794p2Codec.decode(y, resolution.dpiY));
        }

        static int decode(int value, double dpi) {
            return (int)Math.round((double)value / dpi * 500.0);
        }

        static class Resolution {
            double dpiX;
            double dpiY;

            Resolution() {
            }
        }
    }

    private static class Ansi378v2009Am1Codec
    extends Ansi378v2009Codec {
        private Ansi378v2009Am1Codec() {
        }

        @Override
        byte[] encode(List<MutableTemplate> templates) {
            Ansi378v2009Am1Template iotemplate = new Ansi378v2009Am1Template();
            iotemplate.fingerprints = IntStream.range(0, templates.size()).mapToObj(n -> Ansi378v2009Am1Codec.encode2009am1(n, (MutableTemplate)templates.get(n))).collect(Collectors.toList());
            return iotemplate.toByteArray();
        }

        @Override
        List<MutableTemplate> decode(byte[] serialized, boolean permissive) {
            return new Ansi378v2009Am1Template((byte[])serialized, (boolean)permissive).fingerprints.stream().map(fp -> Ansi378v2009Am1Codec.decode(fp)).collect(Collectors.toList());
        }

        static Ansi378v2009Am1Fingerprint encode2009am1(int offset, MutableTemplate template) {
            int resolution = (int)Math.round(196.8503937007874);
            Ansi378v2009Am1Fingerprint iofingerprint = new Ansi378v2009Am1Fingerprint();
            iofingerprint.view = offset;
            iofingerprint.width = template.size.x;
            iofingerprint.height = template.size.y;
            iofingerprint.resolutionX = resolution;
            iofingerprint.resolutionY = resolution;
            iofingerprint.minutiae = template.minutiae.stream().map(m -> Ansi378v2009Am1Codec.encode2009(m)).collect(Collectors.toList());
            return iofingerprint;
        }

        static MutableTemplate decode(Ansi378v2009Am1Fingerprint iofingerprint) {
            Ansi378Codec.Resolution resolution = new Ansi378Codec.Resolution();
            resolution.dpiX = (double)iofingerprint.resolutionX * 2.54;
            resolution.dpiY = (double)iofingerprint.resolutionY * 2.54;
            MutableTemplate template = new MutableTemplate();
            template.size = Ansi378v2009Am1Codec.decode(iofingerprint.width, iofingerprint.height, resolution);
            template.minutiae = iofingerprint.minutiae.stream().map(m -> Ansi378v2009Am1Codec.decode(m, resolution)).collect(Collectors.toList());
            return template;
        }
    }

    private static class Ansi378v2009Codec
    extends Ansi378Codec {
        private Ansi378v2009Codec() {
        }

        @Override
        byte[] encode(List<MutableTemplate> templates) {
            Ansi378v2009Template iotemplate = new Ansi378v2009Template();
            iotemplate.fingerprints = IntStream.range(0, templates.size()).mapToObj(n -> Ansi378v2009Codec.encode2009(n, (MutableTemplate)templates.get(n))).collect(Collectors.toList());
            return iotemplate.toByteArray();
        }

        @Override
        List<MutableTemplate> decode(byte[] serialized, boolean permissive) {
            return new Ansi378v2009Template((byte[])serialized, (boolean)permissive).fingerprints.stream().map(fp -> Ansi378v2009Codec.decode(fp)).collect(Collectors.toList());
        }

        static Ansi378v2009Fingerprint encode2009(int offset, MutableTemplate template) {
            int resolution = (int)Math.round(196.8503937007874);
            Ansi378v2009Fingerprint iofingerprint = new Ansi378v2009Fingerprint();
            iofingerprint.view = offset;
            iofingerprint.width = template.size.x;
            iofingerprint.height = template.size.y;
            iofingerprint.resolutionX = resolution;
            iofingerprint.resolutionY = resolution;
            iofingerprint.minutiae = template.minutiae.stream().map(m -> Ansi378v2009Codec.encode2009(m)).collect(Collectors.toList());
            return iofingerprint;
        }

        static MutableTemplate decode(Ansi378v2009Fingerprint iofingerprint) {
            Ansi378Codec.Resolution resolution = new Ansi378Codec.Resolution();
            resolution.dpiX = (double)iofingerprint.resolutionX * 2.54;
            resolution.dpiY = (double)iofingerprint.resolutionY * 2.54;
            MutableTemplate template = new MutableTemplate();
            template.size = Ansi378v2009Codec.decode(iofingerprint.width, iofingerprint.height, resolution);
            template.minutiae = iofingerprint.minutiae.stream().map(m -> Ansi378v2009Codec.decode(m, resolution)).collect(Collectors.toList());
            return template;
        }

        static Ansi378v2009Minutia encode2009(MutableMinutia minutia) {
            Ansi378v2009Minutia iominutia = new Ansi378v2009Minutia();
            iominutia.positionX = minutia.position.x;
            iominutia.positionY = minutia.position.y;
            iominutia.angle = Ansi378v2009Codec.encodeAngle(minutia.direction);
            iominutia.type = Ansi378v2009Codec.encode2009(minutia.type);
            return iominutia;
        }

        static MutableMinutia decode(Ansi378v2009Minutia iominutia, Ansi378Codec.Resolution resolution) {
            MutableMinutia minutia = new MutableMinutia();
            minutia.position = Ansi378v2009Codec.decode(iominutia.positionX, iominutia.positionY, resolution);
            minutia.direction = Ansi378v2009Codec.decodeAngle(iominutia.angle);
            minutia.type = Ansi378v2009Codec.decode(iominutia.type);
            return minutia;
        }

        static Ansi378v2009MinutiaType encode2009(MinutiaType type) {
            switch (type) {
                case ENDING: {
                    return Ansi378v2009MinutiaType.ENDING;
                }
                case BIFURCATION: {
                    return Ansi378v2009MinutiaType.BIFURCATION;
                }
            }
            return Ansi378v2009MinutiaType.ENDING;
        }

        static MinutiaType decode(Ansi378v2009MinutiaType iotype) {
            switch (iotype) {
                case ENDING: {
                    return MinutiaType.ENDING;
                }
                case BIFURCATION: {
                    return MinutiaType.BIFURCATION;
                }
            }
            return MinutiaType.ENDING;
        }
    }

    private static class Ansi378Codec
    extends TemplateCodec {
        private Ansi378Codec() {
        }

        @Override
        byte[] encode(List<MutableTemplate> templates) {
            int resolution = (int)Math.round(196.8503937007874);
            Ansi378Template iotemplate = new Ansi378Template();
            iotemplate.width = templates.stream().mapToInt(t -> t.size.x).max().orElse(500);
            iotemplate.height = templates.stream().mapToInt(t -> t.size.y).max().orElse(500);
            iotemplate.resolutionX = resolution;
            iotemplate.resolutionY = resolution;
            iotemplate.fingerprints = IntStream.range(0, templates.size()).mapToObj(n -> Ansi378Codec.encode(n, (MutableTemplate)templates.get(n))).collect(Collectors.toList());
            return iotemplate.toByteArray();
        }

        @Override
        List<MutableTemplate> decode(byte[] serialized, boolean permissive) {
            Ansi378Template iotemplate = new Ansi378Template(serialized, permissive);
            Resolution resolution = new Resolution();
            resolution.dpiX = (double)iotemplate.resolutionX * 2.54;
            resolution.dpiY = (double)iotemplate.resolutionY * 2.54;
            return iotemplate.fingerprints.stream().map(fp -> Ansi378Codec.decode(fp, iotemplate, resolution)).collect(Collectors.toList());
        }

        static Ansi378Fingerprint encode(int offset, MutableTemplate template) {
            Ansi378Fingerprint iofingerprint = new Ansi378Fingerprint();
            iofingerprint.view = offset;
            iofingerprint.minutiae = template.minutiae.stream().map(m -> Ansi378Codec.encode(m)).collect(Collectors.toList());
            return iofingerprint;
        }

        static MutableTemplate decode(Ansi378Fingerprint iofingerprint, Ansi378Template iotemplate, Resolution resolution) {
            MutableTemplate template = new MutableTemplate();
            template.size = Ansi378Codec.decode(iotemplate.width, iotemplate.height, resolution);
            template.minutiae = iofingerprint.minutiae.stream().map(m -> Ansi378Codec.decode(m, resolution)).collect(Collectors.toList());
            return template;
        }

        static Ansi378Minutia encode(MutableMinutia minutia) {
            Ansi378Minutia iominutia = new Ansi378Minutia();
            iominutia.positionX = minutia.position.x;
            iominutia.positionY = minutia.position.y;
            iominutia.angle = Ansi378Codec.encodeAngle(minutia.direction);
            iominutia.type = Ansi378Codec.encode(minutia.type);
            return iominutia;
        }

        static MutableMinutia decode(Ansi378Minutia iominutia, Resolution resolution) {
            MutableMinutia minutia = new MutableMinutia();
            minutia.position = Ansi378Codec.decode(iominutia.positionX, iominutia.positionY, resolution);
            minutia.direction = Ansi378Codec.decodeAngle(iominutia.angle);
            minutia.type = Ansi378Codec.decode(iominutia.type);
            return minutia;
        }

        static int encodeAngle(double angle) {
            return (int)Math.ceil(DoubleAngle.complementary(angle) * 0.15915494309189535 * 360.0 / 2.0) % 180;
        }

        static double decodeAngle(int ioangle) {
            return DoubleAngle.complementary((double)((2 * ioangle - 1 + 360) % 360) / 360.0 * (Math.PI * 2));
        }

        static Ansi378MinutiaType encode(MinutiaType type) {
            switch (type) {
                case ENDING: {
                    return Ansi378MinutiaType.ENDING;
                }
                case BIFURCATION: {
                    return Ansi378MinutiaType.BIFURCATION;
                }
            }
            return Ansi378MinutiaType.ENDING;
        }

        static MinutiaType decode(Ansi378MinutiaType iotype) {
            switch (iotype) {
                case ENDING: {
                    return MinutiaType.ENDING;
                }
                case BIFURCATION: {
                    return MinutiaType.BIFURCATION;
                }
            }
            return MinutiaType.ENDING;
        }

        static IntPoint decode(int x, int y, Resolution resolution) {
            return new IntPoint(Ansi378Codec.decode(x, resolution.dpiX), Ansi378Codec.decode(y, resolution.dpiY));
        }

        static int decode(int value, double dpi) {
            return (int)Math.round((double)value / dpi * 500.0);
        }

        static class Resolution {
            double dpiX;
            double dpiY;

            Resolution() {
            }
        }
    }
}

