/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.chars.AbstractChar2ReferenceMap;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Char2ReferenceOpenHashMap<V>
extends AbstractChar2ReferenceMap<V>
implements Serializable,
Cloneable,
Hash {
    protected transient char[] key;
    protected transient V[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet<Map.Entry<Character, V>> entries;
    protected volatile transient CharSet keys;
    protected volatile transient ReferenceCollection<V> values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Char2ReferenceOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new char[this.free];
        this.value = new Object[this.free];
        this.state = new byte[this.free];
    }

    public Char2ReferenceOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Char2ReferenceOpenHashMap() {
        this(16, 0.75f);
    }

    public Char2ReferenceOpenHashMap(Map<? extends Character, ? extends V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2ReferenceOpenHashMap(Map<? extends Character, ? extends V> m) {
        this(m, 0.75f);
    }

    public Char2ReferenceOpenHashMap(Char2ReferenceMap<V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2ReferenceOpenHashMap(Char2ReferenceMap<V> m) {
        this(m, 0.75f);
    }

    public Char2ReferenceOpenHashMap(char[] k, V[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Char2ReferenceOpenHashMap(char[] k, V[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(char k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        char[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(char k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        char[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public V put(char k, V v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            V oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return (V)this.defRetValue;
    }

    @Override
    public V put(Character ok, V ov) {
        V v = ov;
        char k = ok.charValue();
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            V oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.value, null);
    }

    @Override
    public boolean containsKey(char k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public V get(char k) {
        int i = this.findKey(k);
        return (V)(i < 0 ? this.defRetValue : this.value[i]);
    }

    @Override
    public V remove(char k) {
        int i = this.findKey(k);
        if (i < 0) {
            return (V)this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        V v = this.value[i];
        this.value[i] = null;
        return v;
    }

    public V get(Character ok) {
        int i = this.findKey(ok.charValue());
        return (V)(i < 0 ? this.defRetValue : this.value[i]);
    }

    @Override
    public V remove(Object ok) {
        int i = this.findKey(((Character)ok).charValue());
        if (i < 0) {
            return (V)this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        V v = this.value[i];
        this.value[i] = null;
        return v;
    }

    @Override
    public ObjectSet<Map.Entry<Character, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet<Map.Entry<Character, V>>(){

                @Override
                public ObjectIterator<Map.Entry<Character, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Char2ReferenceOpenHashMap.this.findKey(((Character)e.getKey()).charValue());
                    return i >= 0 && Char2ReferenceOpenHashMap.this.value[i] == e.getValue();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Char2ReferenceOpenHashMap.this.findKey(((Character)e.getKey()).charValue());
                    if (i >= 0) {
                        Char2ReferenceOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                @Override
                public int size() {
                    return Char2ReferenceOpenHashMap.this.count;
                }

                @Override
                public void clear() {
                    Char2ReferenceOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    @Override
    public CharSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ReferenceCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Char2ReferenceOpenHashMap.this.count;
                }

                @Override
                public boolean contains(Object v) {
                    return Char2ReferenceOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Char2ReferenceOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        byte[] state = this.state;
        int newN = PRIMES[newP];
        char[] key = this.key;
        char[] newKey = new char[newN];
        V[] value = this.value;
        Object[] newValue = new Object[newN];
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            char k = key[i];
            V v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Char2ReferenceOpenHashMap c;
        try {
            c = (Char2ReferenceOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (char[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            if (this != this.value[i]) {
                t ^= System.identityHashCode(this.value[i]);
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        char[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeChar(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new char[n];
        char[] key = this.key;
        this.value = new Object[n];
        Object[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            char k = s.readChar();
            Object v = s.readObject();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Char2ReferenceOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractCharSet {
        private KeySet() {
        }

        public CharIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Char2ReferenceOpenHashMap.this.count;
        }

        public boolean contains(char k) {
            return Char2ReferenceOpenHashMap.this.containsKey(k);
        }

        public boolean remove(char k) {
            int oldCount = Char2ReferenceOpenHashMap.this.count;
            Char2ReferenceOpenHashMap.this.remove(k);
            return Char2ReferenceOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Char2ReferenceOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements CharIterator {
        public char nextChar() {
            return Char2ReferenceOpenHashMap.this.key[this.nextEntry()];
        }

        public Character next() {
            return Character.valueOf(Char2ReferenceOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Map.Entry<Character, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<Character, V> next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Char2ReferenceOpenHashMap.this.count;
            byte[] state = Char2ReferenceOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Char2ReferenceOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Char2ReferenceOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Char2ReferenceOpenHashMap.this.state[this.last] = 1;
            Char2ReferenceOpenHashMap.this.value[this.last] = null;
            --Char2ReferenceOpenHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Char2ReferenceMap.Entry<V>,
    Map.Entry<Character, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Character getKey() {
            return Character.valueOf(Char2ReferenceOpenHashMap.this.key[this.index]);
        }

        @Override
        public char getCharKey() {
            return Char2ReferenceOpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Char2ReferenceOpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Char2ReferenceOpenHashMap.this.value[this.index];
            Char2ReferenceOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Char2ReferenceOpenHashMap.this.key[this.index] == ((Character)e.getKey()).charValue() && Char2ReferenceOpenHashMap.this.value[this.index] == e.getValue();
        }

        @Override
        public int hashCode() {
            return Char2ReferenceOpenHashMap.this.key[this.index] ^ System.identityHashCode(Char2ReferenceOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Char2ReferenceOpenHashMap.this.key[this.index] + "->" + Char2ReferenceOpenHashMap.this.value[this.index];
        }
    }
}

