/*
 * Decompiled with CFR 0.152.
 */
package com.cogentsystems.jna.cls.fp.example;

import com.cogentsystems.jna.cls.fp.capture.LiveScanDirect;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class SampleProgram {
    public static void main(String[] args) {
        byte[] buffer;
        ByteBuffer buffer2;
        Pointer bufferPointer;
        IntByReference bufferLength;
        PointerByReference bufferReference;
        Options options = new Options();
        options.addOption("?", false, "help");
        options.addOption("h", false, "help");
        options.addOption("a", true, "FIR compression algorithm (1-uncompressed, 2-WSQ)");
        options.addOption("c", true, "capture type (1 - 9)");
        options.addOption("e", true, "EFTS finger position (1 - 10)");
        options.addOption("f", true, "capture finger position (1 - 16)");
        options.addOption("g", true, "get image finger position (1 - 10)");
        options.addOption("i", true, "impression type (0-plain, 1-roll, 2-plain single, 3-palm)");
        options.addOption("m", true, "MMF finger position (1 - 10)");
        options.addOption("n", true, "NFIQ finger position (1 - 10)");
        options.addOption("s", true, "get image save compression algorithm (0-uncompressed, 1-BMP, 2-WSQ, 3-J2K)");
        options.addOption("t", true, "transaction number");
        int captureFingerPosition = 13;
        int captureType = 1;
        String transactionNumber = "TX0000001";
        int impressionType = 0;
        int nfiqFingerPosition = 0;
        int firCompressionAlgorithm = 0;
        int imageSaveType = 2;
        int getImageFingerPosition = 0;
        int mmfFingerPosition = 0;
        int eftsFingerPosition = 0;
        PosixParser clp = new PosixParser();
        try {
            CommandLine commandLine = clp.parse(options, args);
            if (commandLine.hasOption("?") || commandLine.hasOption("h")) {
                SampleProgram.usage(options);
                return;
            }
            if (commandLine.hasOption("a")) {
                firCompressionAlgorithm = Integer.valueOf(commandLine.getOptionValue("a"));
            }
            if (commandLine.hasOption("c")) {
                captureType = Integer.valueOf(commandLine.getOptionValue("c"));
            }
            if (commandLine.hasOption("e")) {
                eftsFingerPosition = Integer.valueOf(commandLine.getOptionValue("e"));
            }
            if (commandLine.hasOption("f")) {
                captureFingerPosition = Integer.valueOf(commandLine.getOptionValue("f"));
            }
            if (commandLine.hasOption("g")) {
                getImageFingerPosition = Integer.valueOf(commandLine.getOptionValue("g"));
            }
            if (commandLine.hasOption("i")) {
                impressionType = Integer.valueOf(commandLine.getOptionValue("i"));
            }
            if (commandLine.hasOption("m")) {
                mmfFingerPosition = Integer.valueOf(commandLine.getOptionValue("m"));
            }
            if (commandLine.hasOption("n")) {
                nfiqFingerPosition = Integer.valueOf(commandLine.getOptionValue("n"));
            }
            if (commandLine.hasOption("s")) {
                imageSaveType = Integer.valueOf(commandLine.getOptionValue("s"));
            }
            if (commandLine.hasOption("t")) {
                transactionNumber = commandLine.getOptionValue("t");
            }
        }
        catch (ParseException e) {
            e.printStackTrace(System.err);
            SampleProgram.usage(options);
            System.exit(1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace(System.err);
            SampleProgram.usage(options);
            System.exit(1);
        }
        int returnCode = LiveScanDirect.CLS_Initialize();
        System.out.println("the return from CLS_Initialize was " + returnCode);
        if (0 != returnCode) {
            System.exit(1);
        }
        returnCode = LiveScanDirect.CLS_SetTransNo(transactionNumber);
        System.out.println("the return from CLS_SetTransNo was " + returnCode);
        if (0 != returnCode) {
            System.out.println("terminating...");
            LiveScanDirect.CLS_Terminate();
            System.exit(1);
        }
        if (nfiqFingerPosition > 0) {
            returnCode = LiveScanDirect.CLS_EnableNFIQ(1);
            System.out.println("the return from CLS_EnableNFIQ was " + returnCode);
            if (0 != returnCode) {
                System.out.println("terminating...");
                LiveScanDirect.CLS_Terminate();
                System.exit(1);
            }
        }
        System.out.println("capture fp...");
        returnCode = LiveScanDirect.CLS_CaptureFP(captureType, captureFingerPosition);
        System.out.println("the return from CLS_CaptureFP was " + returnCode);
        if (0 != returnCode) {
            System.out.println("terminating...");
            LiveScanDirect.CLS_Terminate();
            System.exit(1);
        }
        if (nfiqFingerPosition > 0) {
            IntByReference nfiqReference = new IntByReference();
            returnCode = LiveScanDirect.CLS_GetImageNFIQ(nfiqFingerPosition, nfiqReference, impressionType);
            System.out.println("the return from CLS_GetImageNFIQ was " + returnCode);
            if (0 == returnCode) {
                System.out.println("nfiq = " + nfiqReference.getValue());
            } else {
                System.out.println("terminating...");
                LiveScanDirect.CLS_Terminate();
                System.exit(1);
            }
        }
        if (firCompressionAlgorithm > 0) {
            bufferReference = new PointerByReference();
            bufferLength = new IntByReference();
            returnCode = LiveScanDirect.CLS_ExtractFIR381(firCompressionAlgorithm, bufferReference, bufferLength);
            System.out.println("the return from CLS_ExtractFIR381 was " + returnCode);
            if (0 == returnCode) {
                bufferPointer = bufferReference.getValue();
                buffer2 = ByteBuffer.wrap(bufferPointer.getByteArray(0L, bufferLength.getValue()));
                buffer2.limit(bufferLength.getValue());
                System.out.println("buffer = " + buffer2 + "; length arg = " + bufferLength.getValue());
                System.out.println("free()ing buffer...");
                returnCode = LiveScanDirect.CLS_FreeBuffer(bufferPointer);
                System.out.println("the return from CLS_FreeBuffer was " + returnCode);
            } else {
                System.out.println("terminating...");
                LiveScanDirect.CLS_Terminate();
                System.exit(1);
            }
        }
        if (getImageFingerPosition > 0) {
            bufferReference = new PointerByReference();
            bufferLength = new IntByReference();
            returnCode = LiveScanDirect.CLS_GetImage(impressionType, getImageFingerPosition, imageSaveType, bufferReference, bufferLength);
            System.out.println("the return from CLS_GetImage was " + returnCode);
            if (0 == returnCode) {
                bufferPointer = bufferReference.getValue();
                buffer2 = ByteBuffer.wrap(bufferPointer.getByteArray(0L, bufferLength.getValue()));
                System.out.println("buffer = " + buffer2 + "; length arg = " + bufferLength.getValue());
                byte[] sample = new byte[128];
                System.arraycopy(buffer2.array(), 0, sample, 0, sample.length);
                System.out.println("sample = " + Arrays.toString(sample));
                buffer2.rewind();
                SampleProgram.dump2File(transactionNumber, getImageFingerPosition, buffer2, imageSaveType);
                System.out.println("free()ing buffer...");
                returnCode = LiveScanDirect.CLS_FreeBuffer(bufferPointer);
                System.out.println("the return from CLS_FreeBuffer was " + returnCode);
            } else {
                System.out.println("terminating...");
                LiveScanDirect.CLS_Terminate();
                System.exit(1);
            }
        }
        if (mmfFingerPosition > 0) {
            buffer = new byte[10000];
            bufferLength = new IntByReference();
            returnCode = LiveScanDirect.CLS_ExtractMMF(mmfFingerPosition, buffer, bufferLength);
            System.out.println("the return from CLS_ExtractMMF was " + returnCode);
            if (0 == returnCode) {
                System.out.println("buffer length = " + bufferLength.getValue());
                SampleProgram.dump2MinuFile(transactionNumber, mmfFingerPosition, buffer, bufferLength.getValue(), "mmf");
            } else {
                System.out.println("terminating...");
                LiveScanDirect.CLS_Terminate();
                System.exit(1);
            }
        }
        if (eftsFingerPosition > 0) {
            buffer = new byte[2048];
            bufferLength = new IntByReference();
            returnCode = LiveScanDirect.CLS_ExtractEFTS(eftsFingerPosition, buffer, bufferLength);
            System.out.println("the return from CLS_ExtractEFTS was " + returnCode);
            if (0 == returnCode) {
                System.out.println("buffer length = " + bufferLength.getValue());
                SampleProgram.dump2MinuFile(transactionNumber, mmfFingerPosition, buffer, bufferLength.getValue(), "efts");
            } else {
                System.out.println("terminating...");
                LiveScanDirect.CLS_Terminate();
                System.exit(1);
            }
        }
        returnCode = LiveScanDirect.CLS_Clear();
        System.out.println("the return from CLS_Clear was " + returnCode);
        if (0 != returnCode) {
            System.out.println("terminating...");
            LiveScanDirect.CLS_Terminate();
            System.exit(1);
        }
        returnCode = LiveScanDirect.CLS_GetFlowStatus();
        System.out.println("the return from CLS_GetFlowStatus was " + returnCode);
        returnCode = LiveScanDirect.CLS_GetLastErr();
        System.out.println("the return from CLS_GetLastErr was " + returnCode);
        returnCode = LiveScanDirect.CLS_Terminate();
        System.out.println("the return from CLS_Terminate was " + returnCode);
        System.exit(0);
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(SampleProgram.class.getName(), options);
    }

    private static void dump2File(String transactionNumber, int fingerPosition, ByteBuffer buffer, int imageSaveType) {
        String fileName = String.format("%s_%02d.%s", transactionNumber, fingerPosition, SampleProgram.getExtension(imageSaveType));
        SampleProgram.dumpBuffer(fileName, buffer.array(), buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpBuffer(String fileName, byte[] buffer, int length) {
        File f = new File(fileName);
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(f));
            ((BufferedOutputStream)bos).write(buffer, 0, length);
            ((BufferedOutputStream)bos).flush();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void dump2MinuFile(String transactionNumber, int fingerPosition, byte[] buffer, int bufferLength, String extension) {
        String fileName = String.format("%s_%02d.%s", transactionNumber, fingerPosition, extension);
        SampleProgram.dumpBuffer(fileName, buffer, bufferLength);
    }

    private static String getExtension(int imageSaveType) {
        String result = "unk";
        switch (imageSaveType) {
            case 0: {
                result = "img";
                break;
            }
            case 1: {
                result = "bmp";
                break;
            }
            case 2: {
                result = "wsq";
                break;
            }
            case 3: {
                result = "j2k";
                break;
            }
            default: {
                System.err.println("invalid image save type " + imageSaveType);
            }
        }
        return result;
    }
}

