/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import com.github.akurilov.commons.io.Output;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;

public abstract class BinOutput<T>
implements Output<T> {
    protected final ObjectOutputStream output;

    protected BinOutput(ObjectOutputStream output) {
        this.output = output;
    }

    @Override
    public boolean put(T item) throws IOException {
        this.output.writeUnshared(item);
        return true;
    }

    @Override
    public int put(List<T> buffer, int from, int to) throws IOException {
        this.output.writeUnshared(buffer.subList(from, to).toArray(new Object[to - from]));
        return to - from;
    }

    @Override
    public final int put(List<T> items) throws IOException {
        return this.put(items, 0, items.size());
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    public String toString() {
        return "binOutput<" + this.output + ">";
    }
}

