/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.collection.ArrayOutput;
import com.github.akurilov.commons.io.collection.CircularArrayInput;
import java.io.IOException;
import java.util.List;

public class CircularArrayOutput<T>
extends ArrayOutput<T> {
    public CircularArrayOutput(T[] items) {
        super(items);
    }

    @Override
    public boolean put(T item) throws IOException {
        if (this.i >= this.items.length) {
            this.i = 0;
        }
        return super.put(item);
    }

    @Override
    public int put(List<T> buffer, int from, int to) throws IOException {
        int n = to - from;
        if (buffer.size() > n) {
            return this.put(buffer.subList(from, to), 0, n);
        }
        n = buffer.size();
        if (n < this.items.length) {
            int limit = this.items.length - this.i;
            if (n > limit) {
                this.i = n - limit;
            }
            for (int j = from; j < to; ++j) {
                this.items[this.i++] = buffer.get(j);
            }
        } else {
            this.i = 0;
            for (int j = n - this.items.length; j < n; ++j) {
                this.items[this.i++] = buffer.get(j);
            }
        }
        return n;
    }

    @Override
    public CircularArrayInput<T> getInput() throws IOException {
        return new CircularArrayInput<Object>(this.items);
    }

    @Override
    public final String toString() {
        return "circularArrayOutput<" + this.items.hashCode() + ">";
    }
}

