/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.DeviceListener;
import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.VirtualEngine;
import com.ifractal.utils.ConcurrentListener;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Engine
extends Producer
implements DeviceListener,
VirtualEngine {
    private static Engine engine = null;
    protected static Device[] devices = null;
    protected static Thread[] threads = null;
    protected final Observer observer;
    protected IfpontoDB idb = null;

    public static Engine getInstance(String[] args, IfpontoDB db, Observer obs) {
        if (engine != null) {
            return engine;
        }
        engine = new Engine(args, db, obs);
        return engine;
    }

    private Engine(String[] args, IfpontoDB db, Observer obs) {
        super(obs);
        this.observer = obs;
        this.idb = db;
    }

    protected int getDeviceIndex(String codigo) {
        if (devices == null) {
            return -1;
        }
        for (int i = 0; i < devices.length; ++i) {
            Device dev = devices[i];
            if (dev == null || !dev.codigo.equals(codigo)) continue;
            return i;
        }
        return -1;
    }

    protected Device getDevice(int codigo) {
        int i = this.getDeviceIndex(codigo + "");
        if (i < 0) {
            return null;
        }
        return devices[i];
    }

    @Override
    public <T> Thread call(T context, ConcurrentListener<T> cl, String[] args) {
        Thread th = this.concurrentCall(context, cl, args);
        return th;
    }

    @Override
    public int initDevices(JSONArray devs) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jdev, Object[] pars, int[] c) {
                String nro = "";
                String centralizador = "0";
                String centralizadores = (String)pars[0];
                if (jdev.containsKey((Object)"ativo") && jdev.get((Object)"ativo").toString().equals("0")) {
                    return 0;
                }
                if (jdev.containsKey((Object)"nro")) {
                    nro = jdev.get((Object)"nro").toString();
                }
                if (centralizadores.length() > 0) {
                    for (String r : centralizadores.split(",")) {
                        if (!nro.equals(r.trim())) continue;
                        centralizador = "1";
                        break;
                    }
                }
                jdev.putAll(IfpontoDB.config);
                jdev.put((Object)"centralizador", (Object)centralizador);
                Device dev = Device.getNewDevice(jdev);
                if (dev == null) {
                    Engine.this.sendMessage(3, "Falha configura\u00e7\u00e3o: " + jdev.toString());
                    return 0;
                }
                dev.currentNSR = jdev.containsKey((Object)"nsr") && jdev.get((Object)"nsr") != null ? Integer.parseInt(jdev.get((Object)"nsr").toString()) : 1;
                Engine.devices[c[0]] = dev;
                c[0] = c[0] + 1;
                return 0;
            }
        };
        if (devs == null) {
            return 0;
        }
        if (devices != null) {
            for (Device d : devices) {
                if (d == null || !d.isAlive()) continue;
                return -1;
            }
        }
        int n = devs.size();
        devices = new Device[n];
        threads = new Thread[n];
        String centralizadores = IfpontoDB.config.get("CENTRALIZADORES");
        int[] count = new int[]{0};
        Util.jsonIter(devs, iter, new Object[]{centralizadores}, count);
        return count[0];
    }

    @Override
    public int startAllDevices(Observer obs, DeviceListener dl) {
        int c = 0;
        if (devices == null) {
            return 0;
        }
        for (Device dev : devices) {
            if (dev == null || dev.isAlive()) continue;
            this.startDevice(dev.getCodigo(), obs, dl, dev.currentNSR);
            ++c;
        }
        return c;
    }

    @Override
    public void stopAllDevices() {
        if (devices == null) {
            return;
        }
        for (Device dev : devices) {
            if (dev == null) continue;
            this.stopDevice(dev.getCodigo());
        }
    }

    @Override
    public boolean startDevice(int codigo, Observer obs, DeviceListener dl, int nsr) {
        int i = this.getDeviceIndex(codigo + "");
        if (i < 0) {
            return false;
        }
        Device dev = devices[i];
        if (dev == null) {
            return false;
        }
        Observer[] obss = new Observer[]{obs};
        DeviceListener[] lists = new DeviceListener[]{this, dl};
        Engine.threads[i] = dev.startLoop(this, obss, lists, nsr);
        return true;
    }

    @Override
    public boolean stopDevice(int codigo) {
        Device dev = this.getDevice(codigo);
        if (dev == null) {
            return false;
        }
        dev.stopLoop();
        return true;
    }

    @Override
    public JSONArray getDeviceUsers(String codigo) {
        int i = this.getDeviceIndex(codigo);
        if (i < 0) {
            this.sendMessage(2, "Codigo n\u00e3o cadastrado: " + codigo);
            return null;
        }
        Device dev = devices[i];
        if (dev.isAlive()) {
            dev.sendMessage(3, "Dispositivo em processamento.");
            return null;
        }
        Engine.threads[i] = dev.thread = Thread.currentThread();
        JSONArray users = dev.getUsers();
        dev.thread = null;
        Engine.threads[i] = null;
        return users;
    }

    @Override
    public JSONArray getDBUsers(String nro) {
        JSONArray jusers = this.idb.getDeviceUsers(nro);
        return jusers;
    }

    @Override
    public JSONArray getDBEvents(String nro, int limit) {
        JSONArray jevents = this.idb.getLastEvents(nro, limit);
        return jevents;
    }

    @Override
    public JSONArray getDBDevices() {
        JSONArray jdevices = this.idb.getDevices();
        return jdevices;
    }

    @Override
    public JSONArray getDBPendingUsers(String codigo) {
        JSONArray jlist = this.idb.getPendingUsers(codigo);
        return jlist;
    }

    @Override
    public int getDBNsr(String nro) {
        JSONArray dev = this.idb.getDeviceByNro(Integer.parseInt(nro));
        if (dev == null || dev.size() < 1 || !((JSONObject)dev.get(0)).containsKey((Object)"codigo")) {
            this.sendMessage(3, "Device n\u00e3o encontrado no banco de dados.");
            return 1;
        }
        String codigo = ((JSONObject)dev.get(0)).get((Object)"codigo").toString();
        int nsr = this.idb.getNsr(codigo);
        return nsr;
    }

    @Override
    public void setDBNsr(String nro, int nsr) {
        JSONArray dev = this.idb.getDeviceByNro(Integer.parseInt(nro));
        if (dev == null || dev.size() < 1 || !((JSONObject)dev.get(0)).containsKey((Object)"codigo")) {
            this.sendMessage(3, "Device n\u00e3o encontrado no banco de dados.");
            return;
        }
        String codigo = ((JSONObject)dev.get(0)).get((Object)"codigo").toString();
        this.idb.updateNsr(codigo, Integer.toString(nsr));
    }

    protected JSONObject makeStatus(Device dev, String msg, boolean reached) {
        String filename = dev.path_log + File.separator + "status_" + dev.nro + ".json";
        JSONObject jstatus = new JSONObject();
        long unixtime = new Date().getTime() / 1000L;
        jstatus.put((Object)"unixtime", (Object)unixtime);
        jstatus.put((Object)"msg", (Object)msg);
        jstatus.put((Object)"notificacoes", jstatus.get((Object)"msg"));
        jstatus.put((Object)"ultimo_nsr", (Object)dev.currentNSR);
        if (reached) {
            jstatus.put((Object)"ultimo_contato", (Object)unixtime);
        }
        try {
            FileWriter file = new FileWriter(filename);
            file.write(jstatus.toJSONString());
            file.close();
        }
        catch (IOException ioe) {
            this.sendMessage(3, "Erro ao tentar salvar arquivo: " + filename);
        }
        return jstatus;
    }

    @Override
    public void onStart(JSONObject dev) {
    }

    @Override
    public void onStop(JSONObject dev) {
    }

    @Override
    public void onGetTime(JSONObject dev, Date date) {
    }

    @Override
    public void onSetTime(JSONObject dev, int timediff) {
    }

    @Override
    public void onSendUser(JSONObject dev, JSONObject user, JSONObject res, int pos, int total) {
    }

    @Override
    public void onGetBio(JSONObject dev, JSONObject userBios, int pos, int total) {
        String codigo = dev.get((Object)"codigo").toString();
        Device device = this.getDevice(Integer.parseInt(codigo));
        if (devices == null) {
            return;
        }
        this.idb.updateBio(userBios, false);
        String msg = "Coletando biometrias...";
        JSONObject jstatus = this.makeStatus(device, msg, true);
        this.idb.updateStatus(dev.get((Object)"codigo").toString(), jstatus);
    }

    @Override
    public void onEvents(JSONObject dev, JSONArray offs) {
        if (!this.idb.open(Producer.androidContext, this.observer)) {
            return;
        }
        String codigo = dev.get((Object)"codigo").toString();
        this.idb.updateOffs(codigo, offs);
        Device device = this.getDevice(Integer.parseInt(codigo));
        if (offs != null && offs.size() > 1) {
            String msg = "Coletando registros...";
            JSONObject jstatus = this.makeStatus(device, msg, true);
            this.idb.updateStatus(dev.get((Object)"codigo").toString(), jstatus);
        }
    }

    @Override
    public void onFinalize(JSONObject dev, boolean online, JSONArray users, JSONArray res) {
        if (!this.idb.open(Producer.androidContext, this.observer)) {
            return;
        }
        String codigo = dev.get((Object)"codigo").toString();
        Device device = this.getDevice(Integer.parseInt(codigo));
        if (devices == null) {
            return;
        }
        String msg = "";
        boolean reached = false;
        this.sendMessage(3, "onFinalize: " + online);
        if (online) {
            reached = true;
            msg = "ONLINE";
            this.sendMessage(3, "onFinalize res: " + dev.get((Object)"codigo").toString() + " - " + res.toString());
            this.idb.updatePendingUsers(dev.get((Object)"codigo").toString(), res);
        } else {
            if (!dev.containsKey((Object)"msg")) {
                dev.put((Object)"msg", (Object)"Falha comunicacao...");
            } else {
                reached = true;
            }
            msg = dev.get((Object)"msg").toString();
            this.idb.rollbackPendingUsers(users);
        }
        JSONArray interruptedUsers = this.idb.getProcessingUsers(codigo);
        if (interruptedUsers != null && interruptedUsers.size() > 0) {
            this.sendMessage(3, "rollbackPendingUsers ");
            this.idb.rollbackPendingUsers(interruptedUsers);
        }
        JSONObject jstatus = this.makeStatus(device, msg, reached);
        this.idb.updateStatus(dev.get((Object)"codigo").toString(), jstatus);
    }
}

