/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.ClientListener;
import com.ifractal.ifponto.SIINClient;
import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SIINMonitor
implements ClientListener<String> {
    static SIINClient<String> clientTunnel = null;
    static int port = 0;

    public SIINMonitor(String[] args) {
    }

    @Override
    public void onAvailable(SIINClient<String> cli, String ctx, JSONArray servers) {
        Object newContext;
        Object androidContext;
        System.out.println("onAvailable: " + servers.toString());
        if (servers.size() < 1) {
            return;
        }
        JSONObject serv = (JSONObject)servers.get(0);
        boolean connected = cli.connect(serv, androidContext = null, (String)(newContext = null));
        if (!connected) {
            System.out.println("Server not connect");
        }
    }

    @Override
    public void onStart(SIINClient<String> cli, String ctx, JSONObject dev) {
        System.out.println(ctx);
        System.out.println("onStart device");
    }

    @Override
    public void onStop(SIINClient<String> cli, String ctx, JSONObject dev) {
        System.out.println(ctx);
        System.out.println("onStop device");
    }

    @Override
    public void onGetTime(SIINClient<String> cli, String ctx, JSONObject dev, Date date) {
        System.out.println(ctx);
        System.out.println("onGetTime - " + date);
    }

    @Override
    public void onSetTime(SIINClient<String> cli, String ctx, JSONObject dev, int timediff) {
        System.out.println(ctx);
        System.out.println("onSetTime - diff: " + timediff);
    }

    @Override
    public void onSendUser(SIINClient<String> cli, String ctx, JSONObject dev, JSONObject user, JSONObject res, int pos, int total) {
        System.out.println(ctx);
        System.out.println("onSendUser");
    }

    @Override
    public void onGetBio(SIINClient<String> cli, String ctx, JSONObject dev, JSONObject userBios, int pos, int total) {
        System.out.println(ctx);
        System.out.println("onGetBio");
    }

    @Override
    public void onEvents(SIINClient<String> cli, String ctx, JSONObject dev, JSONArray offs) {
        System.out.println(ctx);
        System.out.println("onEvent");
    }

    @Override
    public void onFinalize(SIINClient<String> cli, String ctx, JSONObject dev, boolean online, JSONArray users, JSONArray res) {
        System.out.println(ctx);
        System.out.println("onFinalize - " + online);
    }

    @Override
    public void onResponse(SIINClient<String> cli, String ctx, String[] params) {
        JSONArray jresp = null;
        JSONParser parser = new JSONParser();
        String rsp = Util.getValueFromArgs(params, "onResponse");
        if (rsp == null) {
            return;
        }
        try {
            jresp = (JSONArray)parser.parse(rsp);
        }
        catch (ParseException pe) {
            System.err.println("JSON invalido: -->" + rsp + "<--");
        }
        if (Util.getValueFromArgs(params, "method").equals("getDBDevices")) {
            System.out.println("ActivityDevices: ");
            System.out.println(jresp.toString());
        }
        System.out.println(ctx);
    }

    @Override
    public void onStart(SIINClient<String> cli, String ctx) {
        System.out.println(ctx);
        System.out.println(" onStart ");
        cli.getDBDevices();
    }

    @Override
    public void onStop(SIINClient<String> cli, String ctx) {
        System.out.println(ctx);
        System.out.println(" onStop ");
    }

    @Override
    public void onFail(SIINClient<String> cli, String ctx, String msg) {
        System.out.println(ctx);
        System.out.println("Fail: " + msg);
    }

    @Override
    public void onSynchronized(SIINClient<String> cli, String ctx) {
        System.out.println(ctx);
        System.out.println(" synchronized ");
    }

    @Override
    public void onEnable(SIINClient<String> cli, String ctx, String c) {
        System.out.println(ctx);
        if (c == null || c.length() < 10) {
            System.out.println("modulo n\u00e3o habilitado.");
            return;
        }
        System.out.println("modulo habilitado: " + c);
        if (clientTunnel != null) {
            return;
        }
        System.out.println("conecta tunnel...");
        SIINClient<String> tncli = new SIINClient<String>(this, "tunnel");
        tncli.connectTunnel();
        clientTunnel = tncli;
    }

    @Override
    public void onMessage(SIINClient<String> cli, String ctx, int level, String msg, int code) {
        String txt = ctx + "|" + Verbosity.getLevel(level) + "|" + code + "| " + msg;
        System.out.println(txt);
    }

    @Override
    public void onConnect(SIINClient<String> cli, String ctx, TunnelPeer<String> p) {
        String ip = p.getIP();
        if (ip.indexOf("127.0.0.1") >= 0) {
            System.out.println("startSIINLoop - " + ctx);
            cli.startSIINLoop();
        }
    }

    @Override
    public void onClose(SIINClient<String> cli, String ctx, TunnelPeer<String> p) {
        System.out.println("conecta local...");
        SIINClient<String> client = new SIINClient<String>(this, "local");
        client.connect(port);
    }

    @Override
    public void onMessage(Producer prod, int vl, String msg, int code) {
        if (vl >= 5) {
            return;
        }
        String klass = prod.getClass().getName();
        String txt = klass + "|" + Verbosity.getLevel(vl) + "|" + code + "| " + msg;
        System.out.println(txt);
    }

    @Override
    public void onMessage(Producer prod, int verbosityLevel, String msg) {
        this.onMessage(prod, verbosityLevel, msg, 0);
    }

    public static final void main(String[] args) throws InterruptedException, NumberFormatException {
        if (args.length < 1) {
            System.err.println("\nUso:");
            System.err.println("\tjava SIINMonitor <CHAVE> <TUNNEL HOST> <TUNNEL PORT>");
            System.err.println("\nExemplo:");
            System.err.println("\tjava SIINMonitor chave 74.50.60.155 80\n");
            System.exit(1);
        }
        SIINMonitor sm = new SIINMonitor(args);
        SIINClient<String> sc = new SIINClient<String>(sm, args[0]);
        if (args.length > 2) {
            System.err.println("connect " + args[1] + ":" + args[2]);
            sc.connectTunnel(args[1], Integer.parseInt(args[2]));
        } else {
            System.err.println("connect default");
            sc.connectTunnel();
        }
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

