/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.henry.hexa.Auth;
import com.henry.hexa.MessageManager;
import com.henry.hexa.MessagePack;
import com.ifractal.ifponto.DeviceExtended;
import com.ifractal.ifponto.HenryContext;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Hexa2
extends DeviceExtended<HenryContext> {
    public static final int SUPREMA_BIO_LEN = 384;
    public static final int QTD_EVENTS = 10;
    private String aes = "";

    public Hexa2(JSONObject config) {
        super(config);
        if (!config.containsKey((Object)"porta")) {
            config.put((Object)"porta", (Object)3000);
        }
    }

    protected MessagePack send_recv(HenryContext conn, String cmd, int timeout, boolean with_aes, int[] err) {
        return this.send_recv(conn, cmd, "", timeout, with_aes, err);
    }

    protected MessagePack send_recv(HenryContext conn, String cmd, String data, int timeout, boolean with_aes, int[] err) {
        return this.send_recv(conn, cmd, data.getBytes(), timeout, with_aes, err);
    }

    protected MessagePack send_recv(HenryContext conn, String cmd, byte[] data, int timeout, boolean with_aes, int[] errout) {
        boolean has_sent;
        MessagePack pack = null;
        String code = "";
        byte[][] bdata = new byte[1][];
        if (conn.availableData() > 0) {
            byte[] trash = conn.receiveData(conn.availableData());
            this.verboseDEBUG("Hexa ===> iFractal (lixo)", trash);
        }
        errout[0] = 1001;
        if (with_aes) {
            code = this.aes;
        }
        byte[] req = MessageManager.loadHeader(conn.next(), cmd.getBytes(), data, code, bdata);
        this.verboseDEBUG("iFractal ===> Hexa (trafegado)", req);
        if (!code.equals("")) {
            this.verboseDEBUG("iFractal ===> Hexa (aberto)", bdata[0]);
        }
        if (!(has_sent = conn.sendData(req))) {
            this.verboseERROR("Falha ao tentar enviar pack.");
            return null;
        }
        byte[] result = new byte[]{};
        int pack_len = -1;
        long start = new Date().getTime() / 1000L;
        try {
            long now;
            while ((now = new Date().getTime() / 1000L) - start <= (long)timeout && (pack == null || now - start <= 2L)) {
                if (conn.availableData() < 1) {
                    Thread.sleep(100L);
                    continue;
                }
                start = new Date().getTime() / 1000L;
                byte[] chunk = conn.receiveData(conn.availableData());
                if (chunk == null) continue;
                if (pack_len < 0) {
                    pack_len = chunk[1] & 0xFF;
                    pack_len += (chunk[2] & 0xFF) * 256;
                }
                this.verboseDEBUG("Hexa ===> iFractal (trafegado)", chunk);
                byte[] current = result;
                result = Util.concatArrays(current, chunk);
                if (result.length - 3 < pack_len) {
                    this.verboseDEBUG(result.length - 3 + " / " + pack_len);
                    continue;
                }
                pack = MessageManager.loadObject(result, code, bdata);
                if (pack != null) {
                    String err;
                    if (!code.equals("")) {
                        this.verboseDEBUG("Hexa ===> iFractal (aberto)", bdata[0]);
                    }
                    if ((err = pack.getErro()) == null) continue;
                    if (cmd.equals("EU")) {
                        char[] e = new char[]{(char)bdata[0][12], (char)bdata[0][13]};
                        err = new String(e);
                    }
                    if ((err = err.trim()).length() == 0) continue;
                    errout[0] = Integer.parseInt(err);
                }
                break;
            }
        }
        catch (NumberFormatException err) {
        }
        catch (Exception e) {
            this.verboseFATAL("Exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return pack;
    }

    private HenryContext init_in() throws InterruptedException {
        HenryContext conn = new HenryContext();
        int timeout = 2000;
        boolean has_conn = conn.connect(this.ip, Integer.parseInt(this.port), timeout);
        if (!has_conn) {
            this.verboseERROR("Falha ao tentar conectar...");
            return null;
        }
        int[] err = new int[1];
        MessagePack pack = this.send_recv(conn, "RA", "00", 30, false, err);
        if (pack == null || pack.getData().length() < 1) {
            conn.disconnect();
            return null;
        }
        Thread.sleep(1000L);
        String data = pack.getData();
        String[] mod_and_exp = String.valueOf(data).split("\\]");
        if (mod_and_exp.length < 2) {
            conn.disconnect();
            return null;
        }
        this.aes = Auth.generateAESKey();
        String login = "1]" + this.config.get((Object)"user") + "]" + this.config.get((Object)"pass") + "]" + this.aes;
        this.verboseDEBUG("Login: " + login);
        String login_encoded = Auth.encodeRSA(mod_and_exp[0], mod_and_exp[1], login);
        conn.reset();
        pack = this.send_recv(conn, "EA", login_encoded, 30, false, err);
        if (pack == null) {
            this.verboseWARN(IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").msg);
            this.config.put((Object)"msg", (Object)"Falha conexao");
            conn.disconnect();
            return null;
        }
        if (err[0] != 0) {
            this.verboseWARN(IFPONTO_config.valueOf((String)"ERRO_LOGIN_SENHA").msg);
            this.config.put((Object)"msg", (Object)"Falha login/senha");
            conn.disconnect();
            return null;
        }
        this.verboseDEBUG("Login confirmado.");
        conn.reset();
        return conn;
    }

    protected HenryContext init() {
        int tries = 3;
        try {
            for (int i = 0; i < tries; ++i) {
                HenryContext conn = this.init_in();
                if (conn != null) {
                    Thread.sleep(2000L);
                    return conn;
                }
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ie) {
            this.verboseFATAL(ie.getMessage());
            return null;
        }
        return null;
    }

    protected void terminate(HenryContext conn) {
        conn.disconnect();
    }

    public String buildUser(JSONObject juser, int[] ret2) throws NumberFormatException {
        String[] refs;
        String mask = "%s[%s[%d";
        String data = null;
        String nome = "";
        String cracha = "";
        int verbio = 0;
        if (!juser.containsKey((Object)"pis")) {
            ret2[0] = IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_PIS").codigo;
            return null;
        }
        String pis = juser.get((Object)"pis").toString();
        if (juser.containsKey((Object)"verificar_biometria")) {
            verbio = Integer.parseInt(juser.get((Object)"verificar_biometria").toString());
        }
        if (juser.containsKey((Object)"nome")) {
            nome = juser.get((Object)"nome").toString();
        }
        if (juser.containsKey((Object)"cracha")) {
            cracha = juser.get((Object)"cracha").toString();
        }
        data = String.format(mask, pis, nome, verbio);
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject cart, Object[] pars, int[] c) {
                if (c[0] >= 2) {
                    return 1;
                }
                if (cart.containsKey((Object)"ativo") && cart.get((Object)"ativo").toString().equals("0")) {
                    return 0;
                }
                String[] rs = (String[])pars[0];
                rs[c[0]] = cart.get((Object)"nro").toString();
                c[0] = c[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        if (juser.containsKey((Object)"nro_cartao")) {
            JSONArray nros = (JSONArray)juser.get((Object)"nro_cartao");
            refs = new String[nros.size()];
            Util.jsonIter(nros, iter2, new Object[]{refs}, count);
        } else {
            refs = new String[]{cracha};
            count[0] = 1;
        }
        if (count[0] > 0) {
            data = data + "[" + count[0] + "[" + refs[0];
            for (int i = 1; i < count[0]; ++i) {
                data = data + "}" + refs[i];
            }
        } else {
            data = data + "[0[";
        }
        ret2[0] = 0;
        return data;
    }

    public int updateUser(HenryContext conn, JSONObject juser, String op) {
        int[] err;
        String query = "1+" + op + "[";
        int[] ret2 = new int[]{0};
        String data = null;
        try {
            data = this.buildUser(juser, ret2);
        }
        catch (NumberFormatException e) {
            data = null;
        }
        if (data == null) {
            return ret2[0];
        }
        MessagePack pack = this.send_recv(conn, "EU", query = query + data, 5, true, err = new int[1]);
        if (pack == null) {
            return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
        }
        if (err[0] != 0) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT").codigo;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        return 0;
    }

    protected int sendSuprema(HenryContext conn, String id, byte[][] temps) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        int r = IFPONTO_config.valueOf((String)"ERRO_INSERT_BIO").codigo;
        for (int i = 0; i < temps.length; ++i) {
            int[] err;
            byte[] buf = ("D]" + id + "}").getBytes();
            byte[] query = Util.concatArrays(buf, ("1}" + i + "{").getBytes(), temps[i]);
            MessagePack pack = this.send_recv(conn, "ED", query, 5, true, err = new int[1]);
            if (pack == null) {
                r = IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
                break;
            }
            if (err[0] != 0) {
                this.verboseERROR("Erro ao tentar inserir biometria: " + err + ")");
                r = IFPONTO_config.valueOf((String)"ERRO_INSERT_BIO").codigo;
                break;
            }
            r = 0;
        }
        return r;
    }

    @Override
    protected int getEndIterDelay() {
        return 10;
    }

    @Override
    public void getInfo(JSONObject conf) {
        String[] pairs;
        String[] fields = new String[]{"TAM_BOB", "LEITOR_CARTAO", "LEITOR_BIOMETRIA", "ID_SOFTWARE", "VERSAO_PRODUTO", "VERSAO_MEM", "VERSAO_PROTOCOLO", "DNS", "GATEWAY", "NR_REP", "SERVER_PORT"};
        HenryContext conn = this.init();
        if (conn == null) {
            return;
        }
        String query = "MODELO";
        for (String f : fields) {
            query = query + "]" + f;
        }
        int[] err = new int[1];
        MessagePack pack = this.send_recv(conn, "RC", query, 10, true, err);
        this.terminate(conn);
        if (pack == null) {
            return;
        }
        String[][] translate = new String[][]{{"TAM_BOB", "bobina"}};
        for (String pair : pairs = pack.getData().split("]")) {
            String[] key_val = pair.split("\\[");
            if (key_val.length < 2) continue;
            for (String[] from_to : translate) {
                if (!key_val[0].equals(from_to[0])) continue;
                key_val[0] = from_to[1];
            }
            conf.put((Object)key_val[0], (Object)key_val[1].trim());
        }
    }

    @Override
    public Date getTime() {
        SimpleDateFormat dtfmt = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        Date dt = null;
        HenryContext conn = this.init();
        if (conn == null) {
            return null;
        }
        int[] err = new int[1];
        MessagePack pack = this.send_recv(conn, "RH", 10, true, err);
        this.terminate(conn);
        if (pack == null) {
            return null;
        }
        try {
            String[] tk = pack.getData().split("]");
            dt = dtfmt.parse(tk[0]);
        }
        catch (ParseException pe) {
            this.verboseERROR(pe.getMessage());
            return null;
        }
        return dt;
    }

    @Override
    public boolean setTime(int timediff) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        Date now = new Date();
        long ready = now.getTime() + (long)(3600000 * timediff);
        HenryContext conn = this.init();
        if (conn == null) {
            return false;
        }
        now.setTime(ready);
        String query = sdf.format(now) + "]00/00/00]00/00/00";
        int[] err = new int[1];
        MessagePack pack = this.send_recv(conn, "EH", query, 5, true, err);
        this.terminate(conn);
        return pack != null;
    }

    @Override
    public int getEvents(JSONArray offs) {
        int initPos;
        int nsr = this.currentNSR + 1;
        int qtdTotal = 0;
        int qtdEvents = 10;
        String[] lines = null;
        int last_nsr = 0;
        HenryContext conn = this.init();
        if (conn == null) {
            return -1;
        }
        int[] err = new int[1];
        MessagePack pack = this.send_recv(conn, "RQ", "R", 120, true, err);
        if (pack == null) {
            return -2;
        }
        String data = pack.getData();
        int finalPos = initPos = data.indexOf("]") + 1;
        while (initPos > 0 && data.length() > finalPos + 1 && data.substring(initPos, finalPos + 1).matches("\\d+")) {
            ++finalPos;
        }
        if (initPos > 0) {
            qtdTotal = Integer.parseInt(data.substring(initPos, finalPos));
        }
        if (qtdTotal > nsr) {
            if (qtdTotal - nsr < 10 && qtdTotal - nsr >= 0) {
                qtdEvents = qtdTotal - nsr + 1;
            }
            if (qtdEvents < 0) {
                qtdEvents = 0;
            }
            String query = "N]" + qtdEvents + "]" + nsr;
            pack = this.send_recv(conn, "RR", query, 120, true, err);
        }
        this.terminate(conn);
        if (pack == null) {
            return -3;
        }
        if (qtdTotal <= nsr) {
            return 0;
        }
        data = pack.getData();
        int pos = data.indexOf("]");
        for (String line : lines = data.substring(pos + 1).split("\r\n")) {
            if (line.length() < 11) continue;
            JSONObject reg = new JSONObject();
            try {
                last_nsr = Integer.parseInt(line.substring(0, 9));
            }
            catch (NumberFormatException e) {
                continue;
            }
            reg.put((Object)"afd", (Object)line);
            reg.put((Object)"nsr", (Object)last_nsr);
            reg.put((Object)"tipo_registro", (Object)line.substring(9, 10));
            if (reg.get((Object)"tipo_registro").toString().equals("3")) {
                reg.put((Object)"data", (Object)line.substring(10, 18));
                reg.put((Object)"hora", (Object)line.substring(18, 22));
                reg.put((Object)"pis", (Object)line.substring(22, 34));
            }
            offs.add((Object)reg);
        }
        if (offs.size() < 1) {
            return 0;
        }
        return last_nsr;
    }

    @Override
    public JSONArray getUsers() {
        int[] err;
        String query;
        MessagePack pack;
        String[] fields = new String[]{"pis", "nome", "verificar_biometria"};
        JSONArray jusers = new JSONArray();
        String mask = "%d]%d";
        int qty = 50;
        int index = 0;
        HenryContext conn = this.init();
        if (conn == null) {
            return null;
        }
        while ((pack = this.send_recv(conn, "RU", query = String.format(mask, qty, index), 5, true, err = new int[1])) != null) {
            String[] users;
            String resp = pack.getData();
            String[] tk = resp.split("\\+");
            int tot = Integer.parseInt(tk[0]);
            index += tot;
            if (tot < 1) break;
            for (String user : users = tk[1].split("\\]")) {
                JSONObject juser = new JSONObject();
                String[] vals = user.split("\\[");
                for (int i = 0; i < fields.length; ++i) {
                    juser.put((Object)fields[i], (Object)vals[i]);
                }
                String[] cards = vals[4].split("\\}");
                JSONArray jcards = new JSONArray();
                juser.put((Object)"nro_cartao", (Object)jcards);
                for (String card : cards) {
                    JSONObject jcard = new JSONObject();
                    jcards.add((Object)jcard);
                    jcard.put((Object)"nro", (Object)card.trim());
                }
                jusers.add((Object)juser);
            }
            if (tot == qty) continue;
        }
        this.terminate(conn);
        return jusers;
    }

    @Override
    public HenryContext openContext() {
        return this.init();
    }

    @Override
    public void closeContext(HenryContext ctx) {
        this.terminate(ctx);
    }

    @Override
    public int updateUser(HenryContext conn, JSONObject juser) {
        return this.updateUser(conn, juser, "I");
    }

    @Override
    public int deleteUser(HenryContext conn, JSONObject juser) {
        return this.updateUser(conn, juser, "E");
    }

    @Override
    public int sendUserBio(HenryContext conn, JSONObject juser) {
        for (String f : new String[]{"cracha", "templates"}) {
            if (juser.containsKey((Object)f)) continue;
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        byte[][] temps = this.getTemplates((JSONArray)juser.get((Object)"templates"), "suprema");
        if (temps == null) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        String id = juser.get((Object)"cracha").toString();
        int r = this.sendSuprema(conn, id, temps);
        return r;
    }

    @Override
    public int deleteUserBio(HenryContext conn, JSONObject juser) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject cart, Object[] pars, int[] c) {
                if (!cart.containsKey((Object)"nro")) {
                    return 0;
                }
                HenryContext conn = (HenryContext)pars[0];
                String[] nros = (String[])pars[1];
                int[] errs = (int[])pars[2];
                String mask = "E]%s";
                String n = cart.get((Object)"nro").toString();
                String query = String.format(mask, n);
                int[] err = new int[1];
                MessagePack pack = Hexa2.this.send_recv(conn, "ED", query, 2, true, err);
                nros[c[0]] = n;
                if (pack == null) {
                    errs[c[0]] = -1;
                    return 0;
                }
                errs[c[0]] = err[0];
                c[0] = c[0] + 1;
                return 0;
            }
        };
        if (!juser.containsKey((Object)"nro_cartao")) {
            return 0;
        }
        int[] count = new int[]{0};
        JSONArray jnros = (JSONArray)juser.get((Object)"nro_cartao");
        String[] nros = new String[jnros.size()];
        int[] errs = new int[jnros.size()];
        Util.jsonIter(jnros, iter2, new Object[]{conn, nros, errs}, count);
        for (int i = 0; i < nros.length; ++i) {
            String nro = nros[i];
            if (errs[i] < 0) {
                this.verboseERROR("Falha na comunicacao ao tentar excluir biometria: " + nro);
                continue;
            }
            if (errs[i] == 0) {
                this.verboseINFO("Biometria excluida: " + nro);
                continue;
            }
            this.verboseINFO("Falha ao tentar excluir: " + nro + " - (" + errs[i] + ")");
        }
        return 0;
    }

    @Override
    public int getUserBio(HenryContext conn, JSONObject juser) {
        int i;
        int[] err;
        if (!juser.containsKey((Object)"cracha")) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_CRACHA").codigo;
        }
        String mask = "D]%s";
        String cracha = juser.get((Object)"cracha").toString();
        String query = String.format(mask, cracha);
        MessagePack pack = this.send_recv(conn, "RD", query, 2, true, err = new int[1]);
        if (pack == null) {
            return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
        }
        if (err[0] != 0) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        byte[] resp = pack.getRawData();
        int qty = resp.length / 384;
        byte[][] temps = new byte[qty][];
        this.verboseDEBUG("Qtd biometrias lidas: " + qty);
        for (i = 0; resp[i] != 123 && i < resp.length; ++i) {
        }
        if (i >= resp.length) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        ++i;
        for (int j = 0; j < qty; ++j) {
            temps[j] = new byte[384];
            System.arraycopy(resp, i, temps[j], 0, 384);
            this.verboseDEBUG("Salva bio: " + (j + 1) + " / " + qty);
            i += 384;
            while (i < resp.length && resp[i] != 123) {
                ++i;
            }
            if (i >= resp.length) break;
            ++i;
        }
        JSONArray jtemps = new JSONArray();
        juser.put((Object)"templates", (Object)jtemps);
        for (int j = 0; j < qty && temps[j] != null; ++j) {
            String[][] fields;
            JSONObject jtemp = new JSONObject();
            jtemps.add((Object)jtemp);
            for (String[] pair : fields = new String[][]{{"encode", "hex"}, {"vendor", "suprema"}}) {
                jtemp.put((Object)pair[0], (Object)pair[1]);
            }
            String t = "";
            for (int k = 0; k < 384; ++k) {
                t = t + String.format("%02X", (byte)(temps[j][k] & 0xFF));
            }
            jtemp.put((Object)"template", (Object)t);
        }
        return 0;
    }

    @Override
    public JSONArray getBioList() {
        String query;
        MessagePack pack;
        String mask = "L]%d}%d";
        int qty = 50;
        int tot = 0;
        int index = 0;
        int[] err = new int[1];
        HenryContext conn = this.init();
        if (conn == null) {
            return null;
        }
        JSONArray jlist = new JSONArray();
        while ((pack = this.send_recv(conn, "RD", query = String.format(mask, qty, index), 30, true, err)) != null) {
            if (err[0] != 0) {
                this.verboseERROR("Falha ao tentar recuperar lista. (" + err + ")");
                return null;
            }
            String resp = pack.getData();
            index += tot;
            System.err.println(resp);
            if (tot == qty) continue;
        }
        this.terminate(conn);
        return jlist;
    }
}

