/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.DeviceExtended;
import com.ifractal.utils.HttpServer;
import com.ifractal.utils.Util;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import org.json.simple.JSONObject;

public abstract class PushDevice<T>
extends DeviceExtended<T> {
    public static final int TIMEOUT = 10;
    public Queue<String> cmdQueue = null;
    public ArrayList<Integer> confirmList = null;
    protected long last = 0L;
    protected int packcnt = 0;
    protected int packidx = 0;
    protected int session = 0;
    protected int cmdid = (int)(new Date().getTime() % 1000L);

    public PushDevice(JSONObject c) {
        super(c);
        this.cmdQueue = new LinkedList<String>();
        this.confirmList = new ArrayList();
    }

    public abstract byte[] handler(String[] var1, String var2, String var3, String[] var4, String var5);

    public abstract boolean checkDevice(String var1, String[] var2);

    public boolean checkDevice(String ip, String[] dataIn, String key) {
        String sn = PushDevice.getSN(dataIn, key);
        if (this.ip.equals(ip)) {
            return true;
        }
        return sn != null && this.SN.equals(sn);
    }

    protected int waitData() {
        int to = 300;
        HttpServer.initServer(this.config);
        long now = new Date().getTime();
        int i = 0;
        int r = 0;
        try {
            for (i = 0; !(i >= to || this.last > now && this.packidx >= this.packcnt && this.confirmList.isEmpty()); ++i) {
                Thread.sleep(100L);
            }
            if (i >= to) {
                System.err.println("TIMEOUT");
                r = -1;
            } else {
                r = i;
            }
        }
        catch (InterruptedException ie) {
            r = -2;
        }
        return r;
    }

    public static String getSN(String[] dataIn, String key) {
        String[] tk = dataIn[0].split(" ");
        if (tk.length < 3) {
            return null;
        }
        if ((tk = tk[1].split("\\?")).length < 2) {
            return null;
        }
        String query = tk[1];
        String[] GET = HttpServer.splitParameters(query, "&", "=");
        return Util.getValueFromArgs(GET, key);
    }

    protected byte[] makeResponse(String content) {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        Date now = new Date();
        String resp = null;
        if (content == null) {
            resp = HttpServer.HTTP_HEADER_ERROR;
        } else {
            resp = HttpServer.HTTP_HEADER;
            resp = resp + "Date: " + fmt.format(now) + "\r\n";
            resp = resp + "Content-Length: " + content.length() + "\r\n\r\n";
            resp = resp + content;
        }
        return resp.getBytes();
    }
}

