/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelNative;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class IFractalServer
extends Producer
implements TunnelListener<String> {
    protected String[] admins = null;

    public IFractalServer(long[] ctx, String[] args) {
        super(ctx, args);
        String adms = Util.getValueFromArgs(args, "admins");
        if (adms != null) {
            this.admins = adms.split(",");
        }
    }

    @Override
    public void onBroadcast(String ctx, TunnelPeer<String> from, TunnelPeer<String> to, String[] pack) {
        if (to.mod != 2 || from == null || to.siin != from) {
            return;
        }
        to.send(pack);
    }

    @Override
    public void peerIter(String ctx, TunnelPeer<String> p, Object user_data) {
        if (user_data == null || !(user_data instanceof Object[])) {
            return;
        }
        Object[] pars = (Object[])user_data;
        if (pars.length < 2 || pars[0] == null || pars[1] == null) {
            return;
        }
        try {
            TunnelServer ts = (TunnelServer)pars[0];
            TunnelPeer ref = (TunnelPeer)pars[1];
            if (ref == p) {
                return;
            }
            if (ref.mod == p.mod) {
                return;
            }
            if (p.info == null) {
                return;
            }
            JSONObject e = (JSONObject)p.info.clone();
            if (p.getIP().equals(ref.getIP())) {
                e.put((Object)"access", (Object)"local");
            } else if (ref.chave.equals(p.chave)) {
                e.put((Object)"access", (Object)"tunnel");
            } else if (this.isAdmin(ref.getIP())) {
                e.put((Object)"access", (Object)"admin");
            } else {
                return;
            }
            if (ref.mod == 2) {
                if (pars.length < 3) {
                    return;
                }
                JSONArray srvs = (JSONArray)pars[2];
                if (srvs == null) {
                    return;
                }
                srvs.add((Object)e);
            } else if (ref.mod == 1) {
                this.sendServers(ts, p);
            }
        }
        catch (ClassCastException cce) {
            this.sendMessage(2, cce.getMessage());
            return;
        }
    }

    public boolean isAdmin(String ip) {
        if (this.admins == null) {
            return false;
        }
        for (String e : this.admins) {
            if (!e.equals(ip)) continue;
            return true;
        }
        return false;
    }

    protected int sendServers(TunnelServer<String> ts, TunnelPeer<String> peer) {
        JSONArray servers = new JSONArray();
        Object[] pars = new Object[]{ts, peer, servers};
        ts.peerIterator(pars);
        String[] msg = new String[]{"servers", servers.toString()};
        peer.send(msg);
        return servers.size();
    }

    private boolean login(String ctx, TunnelServer<String> ts, TunnelPeer<String> peer, String[] pack) {
        JSONObject info = (JSONObject)Util.getJSONFromArgs(pack, "peer");
        boolean r = peer.setInfo(info);
        if (!r) {
            this.sendMessage(2, peer.getIP() + ": setInfo fail...");
            return r;
        }
        if (peer.mod == 1) {
            ts.peerIterator(new Object[]{ts, peer});
            return true;
        }
        this.sendServers(ts, peer);
        return true;
    }

    @Override
    public String onAccept(String ctx, TunnelPeer<String> peer) {
        if (peer == null) {
            return null;
        }
        String ip = peer.getIP();
        this.sendMessage(5, "new peer: " + ip);
        String id = ip + " - " + System.currentTimeMillis();
        return id;
    }

    @Override
    public void onMessage(String ctx, TunnelServer<String> ts, TunnelPeer<String> peer, String[] pack) {
        this.sendMessage(5, "##########################################");
        this.sendMessage(5, "## From: '" + peer.getIP() + "'");
        for (String e : pack) {
            this.sendMessage(5, "'" + e + "'");
        }
        this.sendMessage(5, "##########################################");
        if (Util.checkKeysInArgs(pack, new String[]{"class", "method"})) {
            if (this.isAdmin(peer.getIP())) {
                String[] args = TunnelNative.invoke(pack);
                if (args != null) {
                    peer.send(args);
                }
            } else {
                this.sendMessage(3, "Execucao bloqueada - " + peer.getIP());
            }
            peer.close();
        } else if (Util.checkKeysInArgs(pack, new String[]{"peer"})) {
            if (!this.login(ctx, ts, peer, pack)) {
                peer.close();
            }
        } else if (Util.checkKeysInArgs(pack, new String[]{"match"})) {
            TunnelPeer<String> psiin = ts.getPeer(Util.getValueFromArgs(pack, "match"));
            peer.setSIIN(psiin);
            psiin.send(new String[]{"match", peer.info.toString()});
        } else if (peer.siin != null) {
            peer.siin.send(pack);
        } else if (peer.mod == 1) {
            ts.broadcast(peer, pack);
        } else {
            peer.close();
        }
    }

    @Override
    public void onFail(String ctx, String msg) {
        this.sendMessage(2, msg);
    }

    @Override
    public boolean idle(String ctx) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return true;
    }

    @Override
    public void onClose(String ctx, TunnelPeer<String> peer) {
        this.sendMessage(5, "Close: " + ctx);
    }

    @Override
    public void onMessage(Producer prod, int level, String msg, int code) {
        Verbosity.println(msg);
    }

    @Override
    public void onMessage(Producer prod, int level, String msg) {
        this.onMessage(prod, level, msg, 0);
    }

    public static final Object start(long[] ctx, String[] args) {
        IFractalServer is = new IFractalServer(null, args);
        TunnelNative<String> tn = new TunnelNative<String>(args, "Server", is);
        int port = Util.getIntFromArgs(args, "local_port");
        if (port == 0) {
            Verbosity.println("default port");
            port = 7000;
        }
        Verbosity.println("Listen port " + port);
        if (!tn.open(port)) {
            Verbosity.println("Fail on port " + port);
        } else {
            tn.start();
        }
        return is;
    }

    public static final void main(String[] args) throws InterruptedException {
        if (args.length < 2) {
            System.err.println("\nUso:\n\tjava IFractalServer <KEY 1> <VALUE 1> ... <Key N> VALUE N\n");
            System.err.println("Exemplo:\n\tjava IFractalServer local_port 8000 admins 127.0.0.1,172.30.1.3\n");
            System.exit(1);
        }
        IFractalServer.start(null, args);
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

