/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.ConcurrentListener;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class Producer
implements Observer {
    public static Object androidContext = null;
    public Object context = null;
    protected long[] native_context = null;
    protected Observer[] observers = null;

    protected native int messageC(long[] var1, String[] var2, byte[][] var3);

    @Override
    public void onMessage(Producer p, int level, String msg) {
        this.onMessage(p, level, msg, 0);
    }

    @Override
    public void onMessage(Producer p, int level, String msg, int code) {
        String klass = p.getClass().getName();
        String verb = Verbosity.getLevel(level);
        try {
            String[] args = new String[]{"class", klass, "verbosity", verb, "message", msg, "code", code + ""};
            this.messageC(this.native_context, args, null);
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("(Producer stderr) " + klass + "|" + verb + "|" + code + "|" + msg);
        }
    }

    public Producer() {
    }

    public Producer(long[] ctx, String[] args) {
        this.native_context = ctx;
        this.addObserver(this);
    }

    public Producer(Observer obs) {
        this.addObserver(obs);
    }

    public void setContext(Object c) {
        this.context = c;
    }

    public void setAndroidContext(Object c) {
        androidContext = c;
    }

    public static Object newObject(long[] ctx, String[] args) {
        Constructor<?> constructor = null;
        Class<?> cls = null;
        Object obj = null;
        if (args == null || args.length < 1) {
            return null;
        }
        String klass = Util.getValueFromArgs(args, "class").replace("/", ".");
        try {
            String lib = Util.getValueFromArgs(args, "library");
            if (lib != null) {
                System.loadLibrary(lib);
            }
            cls = Class.forName(klass);
            Class[] args_def = new Class[]{long[].class, String[].class};
            constructor = cls.getConstructor(args_def);
            Object[] c_args = new Object[]{ctx, args};
            obj = constructor.newInstance(c_args);
        }
        catch (ClassNotFoundException ex) {
            Verbosity.println("Classe n\u00e3o encontrada: " + ex.getMessage());
        }
        catch (InstantiationException ie) {
            Verbosity.println(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            Verbosity.println(iae.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            Verbosity.println("Metodo n\u00e3o encontrado: " + nsme.getMessage());
        }
        catch (InvocationTargetException ite) {
            Verbosity.println(ite.getMessage());
        }
        catch (UnsatisfiedLinkError ule) {
            Verbosity.println(ule.getMessage());
        }
        return obj;
    }

    public int sendMessage(int level, String msg) {
        return this.sendMessage(level, msg, 0);
    }

    public int sendMessage(int level, String msg, int target) {
        if (this.observers == null) {
            System.err.println("(no observers)|" + this.getClass() + "|" + Verbosity.getLevel(level) + "|" + msg);
            return 0;
        }
        int i = 0;
        for (Observer obs : this.observers) {
            obs.onMessage(this, level, msg, target);
            ++i;
        }
        return i;
    }

    public int addObserver(Observer obs) {
        if (obs == null) {
            return -1;
        }
        if (this.observers == null) {
            this.observers = new Observer[1];
            this.observers[0] = obs;
            return 1;
        }
        int last = this.observers.length;
        for (Observer o : this.observers) {
            if (o != obs) continue;
            return last;
        }
        Observer[] aux = new Observer[last + 1];
        for (int i = 0; i < last; ++i) {
            aux[i] = this.observers[i];
        }
        aux[last] = obs;
        this.observers = aux;
        return last + 1;
    }

    protected Object[] getCallingContext(String[] args) {
        if (args.length < 2) {
            this.sendMessage(2, "Faltam parametros.");
            return null;
        }
        String method_name = Util.getValueFromArgs(args, "method");
        if (method_name == null) {
            this.sendMessage(2, "Parametros invalidos.");
            return null;
        }
        int offset = 0;
        for (offset = 0; offset < args.length && !args[offset].equals("method"); ++offset) {
        }
        int qty_pars = (args.length - (offset + 2)) / 2;
        Class[] args_def = new Class[qty_pars];
        Object[] values = new Object[qty_pars];
        JSONParser parser = new JSONParser();
        int i = 0;
        int j = 0;
        try {
            i = offset + 2;
            while (i + 1 < args.length) {
                if (args[i].equals("int")) {
                    args_def[j] = Integer.TYPE;
                    values[j++] = Integer.parseInt(args[i + 1]);
                } else if (args[i].equals("String")) {
                    args_def[j] = String.class;
                    values[j++] = args[i + 1];
                } else if (args[i].equals("JSONArray")) {
                    args_def[j] = JSONArray.class;
                    values[j++] = parser.parse(args[i + 1]);
                } else if (args[i].equals("JSONObject")) {
                    args_def[j] = JSONObject.class;
                    values[j++] = parser.parse(args[i + 1]);
                } else {
                    this.sendMessage(2, "Tipo invalido: " + args[i]);
                    return null;
                }
                i += 2;
            }
        }
        catch (NumberFormatException nfe) {
            this.sendMessage(2, "Numero invalido: " + args[i + 1]);
            return null;
        }
        catch (ParseException pe) {
            this.sendMessage(2, "JSON invalido: -->" + args[i + 1] + "<--");
            return null;
        }
        Object[] ctx = new Object[]{method_name, args_def, values};
        return ctx;
    }

    protected <T> T call(T r, Object[] ctx) throws NoSuchMethodException {
        Object ret2;
        block19: {
            String method_name = "";
            ret2 = null;
            try {
                method_name = (String)ctx[0];
                Class[] args_def = (Class[])ctx[1];
                Object[] values = (Object[])ctx[2];
                Class<?> cls = this.getClass();
                Method meth = cls.getMethod(method_name, args_def);
                Class<?> rtype = meth.getReturnType();
                Object out = null;
                if (args_def == null || args_def.length == 0) {
                    out = meth.invoke((Object)this, new Object[0]);
                } else if (args_def.length == 1) {
                    out = meth.invoke((Object)this, values[0]);
                } else if (args_def.length == 2) {
                    out = meth.invoke((Object)this, values[0], values[1]);
                } else if (args_def.length == 3) {
                    out = meth.invoke((Object)this, values[0], values[1], values[2]);
                } else if (args_def.length == 4) {
                    out = meth.invoke((Object)this, values[0], values[1], values[2], values[3]);
                } else if (args_def.length == 5) {
                    out = meth.invoke((Object)this, values[0], values[1], values[2], values[3], values[4]);
                } else {
                    this.sendMessage(2, "Metodo nao executado por excesso de argumentos: " + method_name);
                    return null;
                }
                if (out == null) {
                    return null;
                }
                if (rtype == r.getClass()) {
                    ret2 = out;
                    break block19;
                }
                if (r.getClass() == String.class) {
                    ret2 = out.toString();
                    break block19;
                }
                if (r.getClass() == byte[].class) {
                    ret2 = out.toString().getBytes();
                    break block19;
                }
                this.sendMessage(2, "Tipo retorno incompativel: " + rtype.toString());
                return null;
            }
            catch (IllegalAccessException iae) {
                this.sendMessage(2, method_name + " | " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                this.sendMessage(2, method_name + " - falha execucao...");
            }
        }
        return (T)ret2;
    }

    public String callStringMethod(String[] args) throws NoSuchMethodException {
        Object[] ctx = this.getCallingContext(args);
        if (ctx == null) {
            return null;
        }
        String ret2 = "";
        try {
            ret2 = this.call(ret2, ctx);
        }
        catch (ClassCastException cce) {
            this.sendMessage(2, cce.getMessage());
            return null;
        }
        return ret2;
    }

    public byte[] callBytesMethod(String[] args) throws NoSuchMethodException {
        Object[] ctx = this.getCallingContext(args);
        if (ctx == null) {
            return null;
        }
        byte[] ret2 = new byte[]{};
        try {
            ret2 = this.call(ret2, ctx);
        }
        catch (ClassCastException cce) {
            this.sendMessage(2, cce.getMessage());
            return null;
        }
        return ret2;
    }

    public <T> Thread concurrentCall(final T ctx, final ConcurrentListener<T> cl, final String[] args) {
        if (args == null) {
            return null;
        }
        final String[] pack = new String[args.length];
        System.arraycopy(args, 0, pack, 0, pack.length);
        Runnable rn = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] res = Producer.this.callBytesMethod(pack);
                    if (Util.isBinary(res)) {
                        cl.onData(ctx, Producer.this, args, res);
                    } else {
                        cl.onData(ctx, Producer.this, args, new String(res));
                    }
                }
                catch (NoSuchMethodException nsme) {
                    Producer.this.sendMessage(2, nsme.getMessage());
                    cl.onFail(ctx, Producer.this, args);
                }
            }
        };
        Thread th = new Thread(rn);
        th.start();
        return th;
    }
}

