/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.whatsapp;

import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import com.ifractal.whatsapp.Attendant;
import com.ifractal.whatsapp.Chat;
import com.ifractal.whatsapp.Person;
import com.ifractal.whatsapp.WhatsappBot;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018H\u0016J \u0010\u001e\u001a\u00020\u00162\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016J\u001a\u0010\u001f\u001a\u00020\u00162\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J \u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0016J(\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010&\u001a\u00020%H\u0016J?\u0010!\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016\u00a2\u0006\u0002\u0010*J\u001b\u0010+\u001a\u00020\u001a2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016\u00a2\u0006\u0002\u0010,R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/ifractal/whatsapp/WhatsappServer;", "Lcom/ifractal/whatsapp/WhatsappBot;", "Lcom/ifractal/utils/TunnelListener;", "", "ctx", "", "args", "", "([J[Ljava/lang/String;)V", "SIINURL", "Ljava/net/URL;", "getSIINURL", "()Ljava/net/URL;", "setSIINURL", "(Ljava/net/URL;)V", "servers", "", "getServers", "()Ljava/util/List;", "setServers", "(Ljava/util/List;)V", "handler", "", "peer", "Lcom/ifractal/utils/TunnelPeer;", "jpack", "Lorg/json/simple/JSONObject;", "idle", "", "onAccept", "onClose", "onFail", "msg", "onMessage", "prod", "Lcom/ifractal/utils/Producer;", "level", "", "code", "ts", "Lcom/ifractal/utils/TunnelServer;", "pack", "(Ljava/lang/String;Lcom/ifractal/utils/TunnelServer;Lcom/ifractal/utils/TunnelPeer;[Ljava/lang/String;)V", "perform", "([Ljava/lang/String;)Lorg/json/simple/JSONObject;", "ifractal"})
public final class WhatsappServer
extends WhatsappBot
implements TunnelListener<String> {
    @NotNull
    private List<String> servers;
    @NotNull
    private URL SIINURL;

    public WhatsappServer(@Nullable long[] ctx, @NotNull String[] args) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(ctx, args);
        this.servers = CollectionsKt.emptyList();
        this.SIINURL = new URL("https://ifractal.com.br/");
        String srvs = Util.getValueFromArgs(args, "servers");
        if (srvs == null) {
            this.servers = CollectionsKt.listOf((Object)"127.0.0.1");
        } else {
            stringArray = new String[]{","};
            this.servers = StringsKt.split$default((CharSequence)srvs, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        stringArray = new String[]{"SIINURL"};
        if (Util.checkKeysInArgs(args, stringArray)) {
            this.SIINURL = new URL(Util.getValueFromArgs(args, "SIINURL"));
        }
    }

    @NotNull
    public final List<String> getServers() {
        return this.servers;
    }

    public final void setServers(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.servers = list;
    }

    @NotNull
    public final URL getSIINURL() {
        return this.SIINURL;
    }

    public final void setSIINURL(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.SIINURL = uRL;
    }

    public final void handler(@NotNull TunnelPeer<String> peer, @NotNull JSONObject jpack) {
        Intrinsics.checkNotNullParameter(peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)jpack, (String)"jpack");
        String[] ret2 = this.process(jpack, (Function6<? super String, ? super String, ? super String, ? super String, ? super String, ? super String, Boolean>)((Function6)new Function6<String, String, String, String, String, String, Boolean>(this){
            final /* synthetic */ WhatsappServer this$0;
            {
                this.this$0 = $receiver;
                super(6);
            }

            @NotNull
            public final Boolean invoke(@NotNull String wamid, @NotNull String name, @NotNull String wa_id, @NotNull String type, @NotNull String media_id, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)wamid, (String)"wamid");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)wa_id, (String)"wa_id");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)media_id, (String)"media_id");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Person to = null;
                Chat chat = null;
                Attendant att = this.this$0.getAttendant(wa_id);
                if (att == null) {
                    chat = this.this$0.getClientChat(wa_id);
                    if (chat == null) {
                        chat = this.this$0.addChat(wamid, new Person(name, wa_id, false, null, 0L, null, 60, null));
                    }
                    this.this$0.perform(chat, type, media_id, text);
                } else {
                    chat = this.this$0.getAttendantChat(wa_id);
                    if (chat != null) {
                        to = chat.getClient();
                        this.this$0.forward(to, type, media_id, text);
                    } else {
                        this.this$0.performAttendant(att, type, media_id, text);
                    }
                }
                return true;
            }
        }));
        peer.send(ret2);
    }

    @Override
    @NotNull
    public JSONObject perform(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            String e = args[i];
            System.out.println((Object)e);
        }
        String res = Util.sendFORM(this, this.SIINURL, args);
        if (res == null) {
            return new JSONObject();
        }
        JSONParser parser = new JSONParser();
        try {
            Object object = parser.parse(res);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
            JSONObject r = (JSONObject)object;
            return r;
        }
        catch (Exception e) {
            this.sendMessage(2, e.getMessage());
            return new JSONObject();
        }
    }

    @Override
    @Nullable
    public String onAccept(@NotNull String ctx, @Nullable TunnelPeer<String> peer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (peer == null) {
            return null;
        }
        String string = peer.getIP();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"peer.getIP()");
        String ip = string;
        this.sendMessage(5, "new peer: " + ip);
        String id = ip + " - " + System.currentTimeMillis();
        return id;
    }

    @Override
    public void onMessage(@NotNull String ctx, @NotNull TunnelServer<String> ts, @NotNull TunnelPeer<String> peer, @NotNull String[] pack) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        Intrinsics.checkNotNullParameter(peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        this.sendMessage(5, "##########################################");
        this.sendMessage(5, "## From: '" + peer.getIP() + '\'');
        int n = pack.length;
        for (int i = 0; i < n; ++i) {
            String e = pack[i];
            this.sendMessage(5, '\'' + e + '\'');
        }
        this.sendMessage(5, "##########################################");
        if (pack.length < 2) {
            return;
        }
        Object obj = Util.getJSONFromArgs(pack, "json");
        if (obj != null) {
            JSONObject jpack = (JSONObject)obj;
            this.handler(peer, jpack);
        }
        peer.close();
    }

    @Override
    public void onFail(@Nullable String ctx, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.sendMessage(2, msg);
    }

    @Override
    public boolean idle(@Nullable String ctx) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return true;
    }

    @Override
    public void onClose(@Nullable String ctx, @NotNull TunnelPeer<String> peer) {
        Intrinsics.checkNotNullParameter(peer, (String)"peer");
        this.sendMessage(5, "Close: " + ctx);
    }

    @Override
    public void onMessage(@NotNull Producer prod, int level, @NotNull String msg, int code) {
        Intrinsics.checkNotNullParameter((Object)prod, (String)"prod");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Verbosity.println(msg);
    }

    @Override
    public void onMessage(@NotNull Producer prod, int level, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)prod, (String)"prod");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.onMessage(prod, level, msg, 0);
    }
}

